/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/AverageObjectCountPerSliceMsr.h>

namespace imagedev
{
/// Computes the average number of objects along XY slices inside the volume of interest of a three-dimensional binary image.
class IMAGEDEV_CPP_API AverageObjectCountPerSlice3d final : public GenericAlgorithm
{
public:

    // Command constructor.
    AverageObjectCountPerSlice3d();


    /// Gets the inputObjectImage parameter.
    /// The 3D binary input image.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The 3D binary input image.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the inputMaskImage parameter.
    /// The binary image defining the volume of interest. The measurement is computed from voxels having a value of 1 in this image. If it equals null, the computation is performed from all voxels of the input image. It must have same dimensions as the input image.
    std::shared_ptr< iolink::ImageView > inputMaskImage() const;
    /// Sets the inputMaskImage parameter.
    /// The binary image defining the volume of interest. The measurement is computed from voxels having a value of 1 in this image. If it equals null, the computation is performed from all voxels of the input image. It must have same dimensions as the input image.
    void setInputMaskImage( std::shared_ptr< iolink::ImageView > inputMaskImage );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result.
    AverageObjectCountPerSliceMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes the average number of objects along XY slices inside the volume of interest of a three-dimensional binary image.
/// @param inputObjectImage The 3D binary input image.
/// @param inputMaskImage The binary image defining the volume of interest. The measurement is computed from voxels having a value of 1 in this image. If it equals null, the computation is performed from all voxels of the input image. It must have same dimensions as the input image.
/// @param outputMeasurement The output measurement result.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
AverageObjectCountPerSliceMsr::Ptr
averageObjectCountPerSlice3d( std::shared_ptr< iolink::ImageView > inputObjectImage,
                              std::shared_ptr< iolink::ImageView > inputMaskImage,
                              AverageObjectCountPerSliceMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
