/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Generates a binary image filtering objects connected between two parallel planes of binary or label three-dimensional image.
class IMAGEDEV_CPP_API AxisConnectivity3d final : public GenericAlgorithm
{
public:

    // Command constructor.
    AxisConnectivity3d();


    /// Gets the inputObjectImage parameter.
    /// The binary or label input image.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The binary or label input image.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the originPoint parameter.
    /// The X, Y, and Z pixel coordinates of a point P1 of the first plane.
    iolink::Vector3i32 originPoint() const;
    /// Sets the originPoint parameter.
    /// The X, Y, and Z pixel coordinates of a point P1 of the first plane.
    void setOriginPoint( const iolink::Vector3i32& originPoint );

    /// Gets the planeNormal parameter.
    /// The X, Y, and Z coordinates of the normal N to both planes.
    iolink::Vector3d planeNormal() const;
    /// Sets the planeNormal parameter.
    /// The X, Y, and Z coordinates of the normal N to both planes.
    void setPlaneNormal( const iolink::Vector3d& planeNormal );

    /// Gets the extremity parameter.
    /// The X, Y, and Z pixel coordinates of a point P2 of the second plane.
    iolink::Vector3i32 extremity() const;
    /// Sets the extremity parameter.
    /// The X, Y, and Z pixel coordinates of a point P2 of the second plane.
    void setExtremity( const iolink::Vector3i32& extremity );

    /// Gets the outputBinaryImage parameter.
    /// The binary output image which contains the retained objects. Its dimensions are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The binary output image which contains the retained objects. Its dimensions are forced to the same values as the input.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Generates a binary image filtering objects connected between two parallel planes of binary or label three-dimensional image.
/// @param inputObjectImage The binary or label input image.
/// @param originPoint The X, Y, and Z pixel coordinates of a point P1 of the first plane.
/// @param planeNormal The X, Y, and Z coordinates of the normal N to both planes.
/// @param extremity The X, Y, and Z pixel coordinates of a point P2 of the second plane.
/// @param outputBinaryImage The binary output image which contains the retained objects. Its dimensions are forced to the same values as the input.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
axisConnectivity3d( std::shared_ptr< iolink::ImageView > inputObjectImage,
                    const iolink::Vector3i32& originPoint,
                    const iolink::Vector3d& planeNormal,
                    const iolink::Vector3i32& extremity,
                    std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
