/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/AnalysisMeasurements/AnalysisMsr.h>

namespace imagedev
{
/// Computes a set of measurements globally to an input binary image.
class IMAGEDEV_CPP_API BinaryAnalysis final : public GenericAlgorithm
{
public:

    // Command constructor.
    BinaryAnalysis();


    /// Gets the inputBinaryImage parameter.
    /// The binary input image.
    std::shared_ptr< iolink::ImageView > inputBinaryImage() const;
    /// Sets the inputBinaryImage parameter.
    /// The binary input image.
    void setInputBinaryImage( std::shared_ptr< iolink::ImageView > inputBinaryImage );

    /// Gets the inputIntensityImage parameter.
    /// The intensity input image. If it equals null, the binary input image is used as the intensity input image.
    std::shared_ptr< iolink::ImageView > inputIntensityImage() const;
    /// Sets the inputIntensityImage parameter.
    /// The intensity input image. If it equals null, the binary input image is used as the intensity input image.
    void setInputIntensityImage( std::shared_ptr< iolink::ImageView > inputIntensityImage );

    /// Gets the outputAnalysis parameter.
    /// The input and output analysis. This object defines the features to measure and store the results.
    AnalysisMsr::Ptr outputAnalysis() const;
    /// Sets the outputAnalysis parameter.
    /// The input and output analysis. This object defines the features to measure and store the results.
    void setOutputAnalysis( AnalysisMsr::Ptr outputAnalysis );

    // Method to launch the command.
    void execute();

};

/// Computes a set of measurements globally to an input binary image.
/// @param inputBinaryImage The binary input image.
/// @param inputIntensityImage The intensity input image. If it equals null, the binary input image is used as the intensity input image.
/// @param outputAnalysis The input and output analysis. This object defines the features to measure and store the results.
/// @return Returns the outputAnalysis output parameter.
IMAGEDEV_CPP_API 
AnalysisMsr::Ptr
binaryAnalysis( std::shared_ptr< iolink::ImageView > inputBinaryImage,
                std::shared_ptr< iolink::ImageView > inputIntensityImage,
                AnalysisMsr::Ptr outputAnalysis = nullptr );
} // namespace imagedev
