/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Blends an RGBA input image with a background RGB image into an RGB output image.
class IMAGEDEV_CPP_API BlendAlphaChannelWithImage final : public GenericAlgorithm
{
public:

    // Command constructor.
    BlendAlphaChannelWithImage();


    /// Gets the inputRgbaImage parameter.
    /// The RGBA input image.
    std::shared_ptr< iolink::ImageView > inputRgbaImage() const;
    /// Sets the inputRgbaImage parameter.
    /// The RGBA input image.
    void setInputRgbaImage( std::shared_ptr< iolink::ImageView > inputRgbaImage );

    /// Gets the inputBackgroundImage parameter.
    /// The background input image. Its spatial dimensions and type must be the same as the RGBA input image. If the image has an alpha channel, it is ignored. Its dimensions and type must be the same as the RGBA input image.
    std::shared_ptr< iolink::ImageView > inputBackgroundImage() const;
    /// Sets the inputBackgroundImage parameter.
    /// The background input image. Its spatial dimensions and type must be the same as the RGBA input image. If the image has an alpha channel, it is ignored. Its dimensions and type must be the same as the RGBA input image.
    void setInputBackgroundImage( std::shared_ptr< iolink::ImageView > inputBackgroundImage );

    /// Gets the outputRgbImage parameter.
    /// The RGB output image. Its spatial dimensions and type are forced to the same values as the inputs.
    std::shared_ptr< iolink::ImageView > outputRgbImage() const;
    /// Sets the outputRgbImage parameter.
    /// The RGB output image. Its spatial dimensions and type are forced to the same values as the inputs.
    void setOutputRgbImage( std::shared_ptr< iolink::ImageView > outputRgbImage );

    // Method to launch the command.
    void execute();

};

/// Blends an RGBA input image with a background RGB image into an RGB output image.
/// @param inputRgbaImage The RGBA input image.
/// @param inputBackgroundImage The background input image. Its spatial dimensions and type must be the same as the RGBA input image. If the image has an alpha channel, it is ignored. Its dimensions and type must be the same as the RGBA input image.
/// @param outputRgbImage The RGB output image. Its spatial dimensions and type are forced to the same values as the inputs.
/// @return Returns the outputRgbImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
blendAlphaChannelWithImage( std::shared_ptr< iolink::ImageView > inputRgbaImage,
                            std::shared_ptr< iolink::ImageView > inputBackgroundImage,
                            std::shared_ptr< iolink::ImageView > outputRgbImage = nullptr );
} // namespace imagedev
