/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
// Output structure of the closestBoundaryPoints2d function.
struct ClosestBoundaryPoints2dOutput
{
    /// The output background distance map image. Its dimensions are forced to the same values as the input. Its type is signed 16-bit integer.
    std::shared_ptr< iolink::ImageView > outputMapImage;
    /// The X coordinate image of the closest boundary point, in pixel units. Its dimensions are forced to the same values as the input. Its type is signed 16-bit integer.
    std::shared_ptr< iolink::ImageView > outputImageX;
    /// The Y coordinate image of the closest boundary point, in pixel units. Its dimensions are forced to the same values as the input. Its type is signed 16-bit integer.
    std::shared_ptr< iolink::ImageView > outputImageY;
};

/// Computes the Chamfer distance map of the background of a two-dimensional image and the coordinates of the associated boundary points.
class IMAGEDEV_CPP_API ClosestBoundaryPoints2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    ClosestBoundaryPoints2d();


    /// Gets the inputBinaryImage parameter.
    /// The binary input image.
    std::shared_ptr< iolink::ImageView > inputBinaryImage() const;
    /// Sets the inputBinaryImage parameter.
    /// The binary input image.
    void setInputBinaryImage( std::shared_ptr< iolink::ImageView > inputBinaryImage );

    /// Gets the outputMapImage parameter.
    /// The output background distance map image. Its dimensions are forced to the same values as the input. Its type is signed 16-bit integer.
    std::shared_ptr< iolink::ImageView > outputMapImage() const;
    /// Sets the outputMapImage parameter.
    /// The output background distance map image. Its dimensions are forced to the same values as the input. Its type is signed 16-bit integer.
    void setOutputMapImage( std::shared_ptr< iolink::ImageView > outputMapImage );

    /// Gets the outputImageX parameter.
    /// The X coordinate image of the closest boundary point, in pixel units. Its dimensions are forced to the same values as the input. Its type is signed 16-bit integer.
    std::shared_ptr< iolink::ImageView > outputImageX() const;
    /// Sets the outputImageX parameter.
    /// The X coordinate image of the closest boundary point, in pixel units. Its dimensions are forced to the same values as the input. Its type is signed 16-bit integer.
    void setOutputImageX( std::shared_ptr< iolink::ImageView > outputImageX );

    /// Gets the outputImageY parameter.
    /// The Y coordinate image of the closest boundary point, in pixel units. Its dimensions are forced to the same values as the input. Its type is signed 16-bit integer.
    std::shared_ptr< iolink::ImageView > outputImageY() const;
    /// Sets the outputImageY parameter.
    /// The Y coordinate image of the closest boundary point, in pixel units. Its dimensions are forced to the same values as the input. Its type is signed 16-bit integer.
    void setOutputImageY( std::shared_ptr< iolink::ImageView > outputImageY );

    // Method to launch the command.
    void execute();

};

/// Computes the Chamfer distance map of the background of a two-dimensional image and the coordinates of the associated boundary points.
/// @param inputBinaryImage The binary input image.
/// @param outputMapImage The output background distance map image. Its dimensions are forced to the same values as the input. Its type is signed 16-bit integer.
/// @param outputImageX The X coordinate image of the closest boundary point, in pixel units. Its dimensions are forced to the same values as the input. Its type is signed 16-bit integer.
/// @param outputImageY The Y coordinate image of the closest boundary point, in pixel units. Its dimensions are forced to the same values as the input. Its type is signed 16-bit integer.
/// @return Returns a ClosestBoundaryPoints2dOutput structure containing the outputMapImage, outputImageX and outputImageY output parameters.
IMAGEDEV_CPP_API 
ClosestBoundaryPoints2dOutput
closestBoundaryPoints2d( std::shared_ptr< iolink::ImageView > inputBinaryImage,
                         std::shared_ptr< iolink::ImageView > outputMapImage = nullptr,
                         std::shared_ptr< iolink::ImageView > outputImageX = nullptr,
                         std::shared_ptr< iolink::ImageView > outputImageY = nullptr );
} // namespace imagedev
