/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Converts a color image from a color space to another one.
class IMAGEDEV_CPP_API ColorSpaceConversion final : public GenericAlgorithm
{
public:
    /// The output color space.
    enum ColorSpace
    {
    /// The standard RGB (Red, Green, Blue) color space.
        RGB = 0,
    /// The HSL (Hue, Saturation, Luminance) color space.
        HSL,
    };

    // Command constructor.
    ColorSpaceConversion();


    /// Gets the inputColorImage parameter.
    /// The input color image.
    std::shared_ptr< iolink::ImageView > inputColorImage() const;
    /// Sets the inputColorImage parameter.
    /// The input color image.
    void setInputColorImage( std::shared_ptr< iolink::ImageView > inputColorImage );

    /// Gets the colorSpace parameter.
    /// The output color space.
    ColorSpaceConversion::ColorSpace colorSpace() const;
    /// Sets the colorSpace parameter.
    /// The output color space.
    void setColorSpace( const ColorSpaceConversion::ColorSpace& colorSpace );

    /// Gets the outputColorImage parameter.
    /// The output color image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputColorImage() const;
    /// Sets the outputColorImage parameter.
    /// The output color image. Its dimensions and type are forced to the same values as the input.
    void setOutputColorImage( std::shared_ptr< iolink::ImageView > outputColorImage );

    // Method to launch the command.
    void execute();

};

/// Converts a color image from a color space to another one.
/// @param inputColorImage The input color image.
/// @param colorSpace The output color space.
/// @param outputColorImage The output color image. Its dimensions and type are forced to the same values as the input.
/// @return Returns the outputColorImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
colorSpaceConversion( std::shared_ptr< iolink::ImageView > inputColorImage,
                      ColorSpaceConversion::ColorSpace colorSpace,
                      std::shared_ptr< iolink::ImageView > outputColorImage = nullptr );
} // namespace imagedev
