/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/CompareMsr.h>

namespace imagedev
{
/// Performs a comparison test between two images and outputs the number of pixels that successfully passed the test.
class IMAGEDEV_CPP_API CompareImage final : public GenericAlgorithm
{
public:
    /// The comparison test to perform between images.
    enum ComparisonCriterion
    {
    /// The number of pixels of the first image having an intensity strictly less than in the second image.
        LESS_THAN = 0,
    /// The number of pixels of the first image having an intensity less than or equal to that of the second image.
        LESS_OR_EQUAL,
    /// The number of pixels of the first image having an intensity equal to that of the second image.
        EQUAL_TO,
    /// The number of pixels of the first image having an intensity greater than or equal to that of the second image.
        GREATER_OR_EQUAL,
    /// The number of pixels of the first image having an intensity strictly greater than in the second image.
        GREATER_THAN,
    /// The number of pixels of the first image having an intensity different than in the second image.
        NOT_EQUAL_TO
    };

    // Command constructor.
    CompareImage();


    /// Gets the inputImage1 parameter.
    /// The first input image.
    std::shared_ptr< iolink::ImageView > inputImage1() const;
    /// Sets the inputImage1 parameter.
    /// The first input image.
    void setInputImage1( std::shared_ptr< iolink::ImageView > inputImage1 );

    /// Gets the inputImage2 parameter.
    /// The second input image. Its dimensions and type must be the same as the first input.
    std::shared_ptr< iolink::ImageView > inputImage2() const;
    /// Sets the inputImage2 parameter.
    /// The second input image. Its dimensions and type must be the same as the first input.
    void setInputImage2( std::shared_ptr< iolink::ImageView > inputImage2 );

    /// Gets the comparisonCriterion parameter.
    /// The comparison test to perform between images.
    CompareImage::ComparisonCriterion comparisonCriterion() const;
    /// Sets the comparisonCriterion parameter.
    /// The comparison test to perform between images.
    void setComparisonCriterion( const CompareImage::ComparisonCriterion& comparisonCriterion );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result.
    CompareMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Performs a comparison test between two images and outputs the number of pixels that successfully passed the test.
/// @param inputImage1 The first input image.
/// @param inputImage2 The second input image. Its dimensions and type must be the same as the first input.
/// @param comparisonCriterion The comparison test to perform between images.
/// @param outputMeasurement The output measurement result.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
CompareMsr::Ptr
compareImage( std::shared_ptr< iolink::ImageView > inputImage1,
              std::shared_ptr< iolink::ImageView > inputImage2,
              CompareImage::ComparisonCriterion comparisonCriterion,
              CompareMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
