/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
// Output structure of the complexCenteredFft function.
struct ComplexCenteredFftOutput
{
    /// The output real part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    std::shared_ptr< iolink::ImageView > outputRealImage;
    /// The output imaginary part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    std::shared_ptr< iolink::ImageView > outputImaginaryImage;
};

/// Computes the centered Fast Fourier Transform of an image.
class IMAGEDEV_CPP_API ComplexCenteredFft final : public GenericAlgorithm
{
public:

    // Command constructor.
    ComplexCenteredFft();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the outputRealImage parameter.
    /// The output real part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    std::shared_ptr< iolink::ImageView > outputRealImage() const;
    /// Sets the outputRealImage parameter.
    /// The output real part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    void setOutputRealImage( std::shared_ptr< iolink::ImageView > outputRealImage );

    /// Gets the outputImaginaryImage parameter.
    /// The output imaginary part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    std::shared_ptr< iolink::ImageView > outputImaginaryImage() const;
    /// Sets the outputImaginaryImage parameter.
    /// The output imaginary part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    void setOutputImaginaryImage( std::shared_ptr< iolink::ImageView > outputImaginaryImage );

    // Method to launch the command.
    void execute();

};

/// Computes the centered Fast Fourier Transform of an image.
/// @param inputImage The input image.
/// @param outputRealImage The output real part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
/// @param outputImaginaryImage The output imaginary part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
/// @return Returns a ComplexCenteredFftOutput structure containing the outputRealImage and outputImaginaryImage output parameters.
IMAGEDEV_CPP_API 
ComplexCenteredFftOutput
complexCenteredFft( std::shared_ptr< iolink::ImageView > inputImage,
                    std::shared_ptr< iolink::ImageView > outputRealImage = nullptr,
                    std::shared_ptr< iolink::ImageView > outputImaginaryImage = nullptr );
} // namespace imagedev
