/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
// Output structure of the complexFftInverse function.
struct ComplexFftInverseOutput
{
    /// The output real part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    std::shared_ptr< iolink::ImageView > outputRealImage;
    /// The output imaginary part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    std::shared_ptr< iolink::ImageView > outputImaginaryImage;
};

/// Computes the Fast Fourier inverse Transform of an image.
class IMAGEDEV_CPP_API ComplexFftInverse final : public GenericAlgorithm
{
public:

    // Command constructor.
    ComplexFftInverse();


    /// Gets the inputRealImage parameter.
    /// The real part input image. It must be a floating point image.
    std::shared_ptr< iolink::ImageView > inputRealImage() const;
    /// Sets the inputRealImage parameter.
    /// The real part input image. It must be a floating point image.
    void setInputRealImage( std::shared_ptr< iolink::ImageView > inputRealImage );

    /// Gets the inputImaginaryImage parameter.
    /// The imaginary part input image. This image must have same dimensions and data type as the real input image.
    std::shared_ptr< iolink::ImageView > inputImaginaryImage() const;
    /// Sets the inputImaginaryImage parameter.
    /// The imaginary part input image. This image must have same dimensions and data type as the real input image.
    void setInputImaginaryImage( std::shared_ptr< iolink::ImageView > inputImaginaryImage );

    /// Gets the outputRealImage parameter.
    /// The output real part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    std::shared_ptr< iolink::ImageView > outputRealImage() const;
    /// Sets the outputRealImage parameter.
    /// The output real part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    void setOutputRealImage( std::shared_ptr< iolink::ImageView > outputRealImage );

    /// Gets the outputImaginaryImage parameter.
    /// The output imaginary part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    std::shared_ptr< iolink::ImageView > outputImaginaryImage() const;
    /// Sets the outputImaginaryImage parameter.
    /// The output imaginary part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
    void setOutputImaginaryImage( std::shared_ptr< iolink::ImageView > outputImaginaryImage );

    // Method to launch the command.
    void execute();

};

/// Computes the Fast Fourier inverse Transform of an image.
/// @param inputRealImage The real part input image. It must be a floating point image.
/// @param inputImaginaryImage The imaginary part input image. This image must have same dimensions and data type as the real input image.
/// @param outputRealImage The output real part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
/// @param outputImaginaryImage The output imaginary part image. Its dimensions are forced to the same values as the input. Its data type is forced to floating point.
/// @return Returns a ComplexFftInverseOutput structure containing the outputRealImage and outputImaginaryImage output parameters.
IMAGEDEV_CPP_API 
ComplexFftInverseOutput
complexFftInverse( std::shared_ptr< iolink::ImageView > inputRealImage,
                   std::shared_ptr< iolink::ImageView > inputImaginaryImage,
                   std::shared_ptr< iolink::ImageView > outputRealImage = nullptr,
                   std::shared_ptr< iolink::ImageView > outputImaginaryImage = nullptr );
} // namespace imagedev
