/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Changes the data type and interpretation of an image.
class IMAGEDEV_CPP_API ConvertImage final : public GenericAlgorithm
{
public:
    /// The output image data type.
    enum OutputType
    {
    /// The output image data type is 1 byte depth. Its possible intensities are unsigned integer from 0 to 255.
        UNSIGNED_INTEGER_8_BIT = 0,
    /// The output image data type is 1 byte depth. Its possible intensities are signed integer from -128 to 127.
        SIGNED_INTEGER_8_BIT,
    /// The output image data type is 2 bytes depth. Its possible intensities are unsigned integer from 0 to 65,535.
        UNSIGNED_INTEGER_16_BIT,
    /// The output image data type is 2 bytes depth. Its possible intensities are signed integer from -32,768 to 32,767.
        SIGNED_INTEGER_16_BIT,
    /// The output image data type is 4 bytes depth. Its possible intensities are unsigned integer from 0 to 4,294,967,295.
        UNSIGNED_INTEGER_32_BIT,
    /// The output image data type is 4 bytes depth. Its possible intensities are signed integer from -2,147,483,648 to 2,147,483,647.
        SIGNED_INTEGER_32_BIT,
    /// The output image data type is 4 bytes depth. Its possible intensities are signed floating-point from -3.402823E38 to 3.402823E38.
        FLOAT_32_BIT,
    /// The output image data type is 8 bytes depth. Its possible intensities are signed floating-point from -1.797693E308 to 1.797693E308.
        FLOAT_64_BIT,
    /// The output image data type is a complex of two 32-bit real floating-point.
        COMPLEX_FLOAT_32_BIT,
    /// The output image data type is a complex of two 64-bit real floating-point.
        COMPLEX_FLOAT_64_BIT,
    /// The output image data type is 1 byte depth and interpretation is binary. Its possible intensities are unsigned integer from 0 to 1.
        BINARY,
    /// The output image data type is 1 byte depth and interpretation is label. Its possible intensities are unsigned integer from 0 to 255.
        LABEL_8_BIT,
    /// The output image data type is 2 bytes depth and interpretation is label. Its possible intensities are unsigned integer from 0 to 65,535.
        LABEL_16_BIT,
    /// The output image data type is 4 bytes depth and interpretation is label. Its possible intensities are unsigned integer from 0 to 4,294,967,295.
        LABEL_32_BIT
    };

    // Command constructor.
    ConvertImage();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the outputType parameter.
    /// The output image data type.
    ConvertImage::OutputType outputType() const;
    /// Sets the outputType parameter.
    /// The output image data type.
    void setOutputType( const ConvertImage::OutputType& outputType );

    /// Gets the outputImage parameter.
    /// The output image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Changes the data type and interpretation of an image.
/// @param inputImage The input image.
/// @param outputType The output image data type.
/// @param outputImage The output image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
convertImage( std::shared_ptr< iolink::ImageView > inputImage,
              ConvertImage::OutputType outputType,
              std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
