/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Performs a two-dimensional dilation using a structuring element matching with a line.
class IMAGEDEV_CPP_API DilationLine2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    DilationLine2d();


    /// Gets the inputImage parameter.
    /// The input image. The image type can be integer or float.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image. The image type can be integer or float.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the orientationAngle parameter.
    /// The angle of orientation in degrees.
    double orientationAngle() const;
    /// Sets the orientationAngle parameter.
    /// The angle of orientation in degrees.
    void setOrientationAngle( const double& orientationAngle );

    /// Gets the kernelRadius parameter.
    /// The length of the linear structuring element in pixels.
    uint32_t kernelRadius() const;
    /// Sets the kernelRadius parameter.
    /// The length of the linear structuring element in pixels.
    void setKernelRadius( const uint32_t& kernelRadius );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Performs a two-dimensional dilation using a structuring element matching with a line.
/// @param inputImage The input image. The image type can be integer or float.
/// @param orientationAngle The angle of orientation in degrees.
/// @param kernelRadius The length of the linear structuring element in pixels.
/// @param outputImage The output image. Its dimensions and type are forced to the same values as the input image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
dilationLine2d( std::shared_ptr< iolink::ImageView > inputImage,
                double orientationAngle,
                uint32_t kernelRadius,
                std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
