/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Fills holes of border faces of a three-dimensional binary image.
class IMAGEDEV_CPP_API FillImageBorder3d final : public GenericAlgorithm
{
public:
    /// The 2D neighborhood configuration for performing numerical reconstruction.
    enum Neighborhood
    {
    /// Morphological reconstruction is performed with a 8-neighbor connectivity.
        CONNECTIVITY_8 = 0,
    /// Morphological reconstruction is performed with a 4-neighbor connectivity.
        CONNECTIVITY_4
    };

    // Command constructor.
    FillImageBorder3d();


    /// Gets the inputObjectImage parameter.
    /// The 3D binary input image.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The 3D binary input image.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the neighborhood parameter.
    /// The 2D neighborhood configuration for performing numerical reconstruction.
    FillImageBorder3d::Neighborhood neighborhood() const;
    /// Sets the neighborhood parameter.
    /// The 2D neighborhood configuration for performing numerical reconstruction.
    void setNeighborhood( const FillImageBorder3d::Neighborhood& neighborhood );

    /// Gets the outputObjectImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input image.
    std::shared_ptr< iolink::ImageView > outputObjectImage() const;
    /// Sets the outputObjectImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input image.
    void setOutputObjectImage( std::shared_ptr< iolink::ImageView > outputObjectImage );

    // Method to launch the command.
    void execute();

};

/// Fills holes of border faces of a three-dimensional binary image.
/// @param inputObjectImage The 3D binary input image.
/// @param neighborhood The 2D neighborhood configuration for performing numerical reconstruction.
/// @param outputObjectImage The output binary image. Its dimensions are forced to the same values as the input image.
/// @return Returns the outputObjectImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
fillImageBorder3d( std::shared_ptr< iolink::ImageView > inputObjectImage,
                   FillImageBorder3d::Neighborhood neighborhood,
                   std::shared_ptr< iolink::ImageView > outputObjectImage = nullptr );
} // namespace imagedev
