/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/FractalMsr.h>

namespace imagedev
{
/// Measures the fractal dimension represented by objects of a binary image.
class IMAGEDEV_CPP_API FractalDimension final : public GenericAlgorithm
{
public:
    /// The way to apply the algorithm, considering all point or only object boundaries.
    enum UseOnlyBorders
    {
    /// All foreground points (that is, having a 1-value) are considered by the algorithm.
        NO = 0,
    /// Only foreground points having a 0-value neighbor are considered by the algorithm.
        YES
    };

    // Command constructor.
    FractalDimension();


    /// Gets the inputBinaryImage parameter.
    /// The input binary image.
    std::shared_ptr< iolink::ImageView > inputBinaryImage() const;
    /// Sets the inputBinaryImage parameter.
    /// The input binary image.
    void setInputBinaryImage( std::shared_ptr< iolink::ImageView > inputBinaryImage );

    /// Gets the useOnlyBorders parameter.
    /// The way to apply the algorithm, considering all point or only object boundaries.
    FractalDimension::UseOnlyBorders useOnlyBorders() const;
    /// Sets the useOnlyBorders parameter.
    /// The way to apply the algorithm, considering all point or only object boundaries.
    void setUseOnlyBorders( const FractalDimension::UseOnlyBorders& useOnlyBorders );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result.
    FractalMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Measures the fractal dimension represented by objects of a binary image.
/// @param inputBinaryImage The input binary image.
/// @param useOnlyBorders The way to apply the algorithm, considering all point or only object boundaries.
/// @param outputMeasurement The output measurement result.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
FractalMsr::Ptr
fractalDimension( std::shared_ptr< iolink::ImageView > inputBinaryImage,
                  FractalDimension::UseOnlyBorders useOnlyBorders,
                  FractalMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
