/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Extracts a slice orthogonal to an axis of a 3D volume.
class IMAGEDEV_CPP_API GetSliceFromVolume3d final : public GenericAlgorithm
{
public:
    /// The axis orthogonal to the plane to extract.
    enum Axis
    {
    /// This mode extracts a plane orthogonal to X axis.
        X_AXIS = 0,
    /// This mode extracts a plane orthogonal to Y axis.
        Y_AXIS,
    /// This mode extracts a plane orthogonal to Z axis.
        Z_AXIS
    };

    // Command constructor.
    GetSliceFromVolume3d();


    /// Gets the inputImage parameter.
    /// The input 3D image (the volume from which the slice is extracted).
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input 3D image (the volume from which the slice is extracted).
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the axis parameter.
    /// The axis orthogonal to the plane to extract.
    GetSliceFromVolume3d::Axis axis() const;
    /// Sets the axis parameter.
    /// The axis orthogonal to the plane to extract.
    void setAxis( const GetSliceFromVolume3d::Axis& axis );

    /// Gets the sliceIndex parameter.
    /// The axis index of the plane to extract.
    int32_t sliceIndex() const;
    /// Sets the sliceIndex parameter.
    /// The axis index of the plane to extract.
    void setSliceIndex( const int32_t& sliceIndex );

    /// Gets the outputImage parameter.
    /// The output 2D image (the extracted slice).
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output 2D image (the extracted slice).
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Extracts a slice orthogonal to an axis of a 3D volume.
/// @param inputImage The input 3D image (the volume from which the slice is extracted).
/// @param axis The axis orthogonal to the plane to extract.
/// @param sliceIndex The axis index of the plane to extract.
/// @param outputImage The output 2D image (the extracted slice).
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
getSliceFromVolume3d( std::shared_ptr< iolink::ImageView > inputImage,
                      GetSliceFromVolume3d::Axis axis,
                      int32_t sliceIndex,
                      std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
