/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Combines three grayscale input images into a single RGB output image.
class IMAGEDEV_CPP_API GrayscaleToColor final : public GenericAlgorithm
{
public:

    // Command constructor.
    GrayscaleToColor();


    /// Gets the inputGrayImage1 parameter.
    /// The first channel input image (red component).
    std::shared_ptr< iolink::ImageView > inputGrayImage1() const;
    /// Sets the inputGrayImage1 parameter.
    /// The first channel input image (red component).
    void setInputGrayImage1( std::shared_ptr< iolink::ImageView > inputGrayImage1 );

    /// Gets the inputGrayImage2 parameter.
    /// The second channel input image (green component). Its dimensions and type must be the same as the first input.
    std::shared_ptr< iolink::ImageView > inputGrayImage2() const;
    /// Sets the inputGrayImage2 parameter.
    /// The second channel input image (green component). Its dimensions and type must be the same as the first input.
    void setInputGrayImage2( std::shared_ptr< iolink::ImageView > inputGrayImage2 );

    /// Gets the inputGrayImage3 parameter.
    /// The third channel input image (blue component). Its dimensions and type must be the same as the first input.
    std::shared_ptr< iolink::ImageView > inputGrayImage3() const;
    /// Sets the inputGrayImage3 parameter.
    /// The third channel input image (blue component). Its dimensions and type must be the same as the first input.
    void setInputGrayImage3( std::shared_ptr< iolink::ImageView > inputGrayImage3 );

    /// Gets the outputColorImage parameter.
    /// The output image. Its spatial dimensions and type are forced to the same values as the inputs.
    std::shared_ptr< iolink::ImageView > outputColorImage() const;
    /// Sets the outputColorImage parameter.
    /// The output image. Its spatial dimensions and type are forced to the same values as the inputs.
    void setOutputColorImage( std::shared_ptr< iolink::ImageView > outputColorImage );

    // Method to launch the command.
    void execute();

};

/// Combines three grayscale input images into a single RGB output image.
/// @param inputGrayImage1 The first channel input image (red component).
/// @param inputGrayImage2 The second channel input image (green component). Its dimensions and type must be the same as the first input.
/// @param inputGrayImage3 The third channel input image (blue component). Its dimensions and type must be the same as the first input.
/// @param outputColorImage The output image. Its spatial dimensions and type are forced to the same values as the inputs.
/// @return Returns the outputColorImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
grayscaleToColor( std::shared_ptr< iolink::ImageView > inputGrayImage1,
                  std::shared_ptr< iolink::ImageView > inputGrayImage2,
                  std::shared_ptr< iolink::ImageView > inputGrayImage3,
                  std::shared_ptr< iolink::ImageView > outputColorImage = nullptr );
} // namespace imagedev
