/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/MeanInertiaMomentMsr.h>

namespace imagedev
{
/// Measures the resistance of an object, defined by a two-dimensional binary image, to changes in its motion around a given axis of rotation.
class IMAGEDEV_CPP_API InertiaMoment2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    InertiaMoment2d();


    /// Gets the inputBinaryImage parameter.
    /// The input binary image.
    std::shared_ptr< iolink::ImageView > inputBinaryImage() const;
    /// Sets the inputBinaryImage parameter.
    /// The input binary image.
    void setInputBinaryImage( std::shared_ptr< iolink::ImageView > inputBinaryImage );

    /// Gets the rotationCenterX parameter.
    /// The X pixel coordinate of the rotation axis.
    int32_t rotationCenterX() const;
    /// Sets the rotationCenterX parameter.
    /// The X pixel coordinate of the rotation axis.
    void setRotationCenterX( const int32_t& rotationCenterX );

    /// Gets the rotationCenterY parameter.
    /// The Y pixel coordinate of the rotation axis.
    int32_t rotationCenterY() const;
    /// Sets the rotationCenterY parameter.
    /// The Y pixel coordinate of the rotation axis.
    void setRotationCenterY( const int32_t& rotationCenterY );

    /// Gets the rotationAngle parameter.
    /// The orientation of the rotation axis in degrees. A positive value means that the angle is taken from the positive X axis to the positive Y axis.
    double rotationAngle() const;
    /// Sets the rotationAngle parameter.
    /// The orientation of the rotation axis in degrees. A positive value means that the angle is taken from the positive X axis to the positive Y axis.
    void setRotationAngle( const double& rotationAngle );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result.
    MeanInertiaMomentMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Measures the resistance of an object, defined by a two-dimensional binary image, to changes in its motion around a given axis of rotation.
/// @param inputBinaryImage The input binary image.
/// @param rotationCenterX The X pixel coordinate of the rotation axis.
/// @param rotationCenterY The Y pixel coordinate of the rotation axis.
/// @param rotationAngle The orientation of the rotation axis in degrees. A positive value means that the angle is taken from the positive X axis to the positive Y axis.
/// @param outputMeasurement The output measurement result.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
MeanInertiaMomentMsr::Ptr
inertiaMoment2d( std::shared_ptr< iolink::ImageView > inputBinaryImage,
                 int32_t rotationCenterX,
                 int32_t rotationCenterY,
                 double rotationAngle,
                 MeanInertiaMomentMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
