/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Converts a multispectral image input into a sequence.
class IMAGEDEV_CPP_API MultispectralToSequence final : public GenericAlgorithm
{
public:

    // Command constructor.
    MultispectralToSequence();


    /// Gets the inputColorImage parameter.
    /// The input multispectral image of type MULTISPECTRAL_IMAGE or MULTISPECTRAL_VOLUME.
    std::shared_ptr< iolink::ImageView > inputColorImage() const;
    /// Sets the inputColorImage parameter.
    /// The input multispectral image of type MULTISPECTRAL_IMAGE or MULTISPECTRAL_VOLUME.
    void setInputColorImage( std::shared_ptr< iolink::ImageView > inputColorImage );

    /// Gets the outputSequence parameter.
    /// The output image of type IMAGE_SEQUENCE or VOLUME_SEQUENCE. Its spatial dimensions  and type are forced to the same values as the input. Its number of frames is equal to the  number of channels of the input.
    std::shared_ptr< iolink::ImageView > outputSequence() const;
    /// Sets the outputSequence parameter.
    /// The output image of type IMAGE_SEQUENCE or VOLUME_SEQUENCE. Its spatial dimensions  and type are forced to the same values as the input. Its number of frames is equal to the  number of channels of the input.
    void setOutputSequence( std::shared_ptr< iolink::ImageView > outputSequence );

    // Method to launch the command.
    void execute();

};

/// Converts a multispectral image input into a sequence.
/// @param inputColorImage The input multispectral image of type MULTISPECTRAL_IMAGE or MULTISPECTRAL_VOLUME.
/// @param outputSequence The output image of type IMAGE_SEQUENCE or VOLUME_SEQUENCE. Its spatial dimensions  and type are forced to the same values as the input. Its number of frames is equal to the  number of channels of the input.
/// @return Returns the outputSequence output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
multispectralToSequence( std::shared_ptr< iolink::ImageView > inputColorImage, std::shared_ptr< iolink::ImageView > outputSequence = nullptr );
} // namespace imagedev
