/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Performs an opening on a true-color image using a structuring element matching with a square.
class IMAGEDEV_CPP_API OpeningColor2d final : public GenericAlgorithm
{
public:
    /// The plane on which the criterion is computed.
    enum CriterionPlane
    {
    /// The operation is applied on the luminance component of the color image.
        LUMINANCE = 0,
    /// The operation is applied on the saturation component of the color image.
        SATURATION
    };

    // Command constructor.
    OpeningColor2d();


    /// Gets the inputColorImage parameter.
    /// The input color image.
    std::shared_ptr< iolink::ImageView > inputColorImage() const;
    /// Sets the inputColorImage parameter.
    /// The input color image.
    void setInputColorImage( std::shared_ptr< iolink::ImageView > inputColorImage );

    /// Gets the kernelRadius parameter.
    /// The half size of the structuring element in pixels. A structuring element always has an odd side length (3x3, 5x5, etc.) which is defined by twice the kernel radius + 1.
    int32_t kernelRadius() const;
    /// Sets the kernelRadius parameter.
    /// The half size of the structuring element in pixels. A structuring element always has an odd side length (3x3, 5x5, etc.) which is defined by twice the kernel radius + 1.
    void setKernelRadius( const int32_t& kernelRadius );

    /// Gets the criterionPlane parameter.
    /// The plane on which the criterion is computed.
    OpeningColor2d::CriterionPlane criterionPlane() const;
    /// Sets the criterionPlane parameter.
    /// The plane on which the criterion is computed.
    void setCriterionPlane( const OpeningColor2d::CriterionPlane& criterionPlane );

    /// Gets the outputColorImage parameter.
    /// The output color image. Its dimensions and type are forced to the same values as the input image.
    std::shared_ptr< iolink::ImageView > outputColorImage() const;
    /// Sets the outputColorImage parameter.
    /// The output color image. Its dimensions and type are forced to the same values as the input image.
    void setOutputColorImage( std::shared_ptr< iolink::ImageView > outputColorImage );

    // Method to launch the command.
    void execute();

};

/// Performs an opening on a true-color image using a structuring element matching with a square.
/// @param inputColorImage The input color image.
/// @param kernelRadius The half size of the structuring element in pixels. A structuring element always has an odd side length (3x3, 5x5, etc.) which is defined by twice the kernel radius + 1.
/// @param criterionPlane The plane on which the criterion is computed.
/// @param outputColorImage The output color image. Its dimensions and type are forced to the same values as the input image.
/// @return Returns the outputColorImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
openingColor2d( std::shared_ptr< iolink::ImageView > inputColorImage,
                int32_t kernelRadius,
                OpeningColor2d::CriterionPlane criterionPlane,
                std::shared_ptr< iolink::ImageView > outputColorImage = nullptr );
} // namespace imagedev
