/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/PeakExtractorMsr.h>

namespace imagedev
{
/// Extracts the peaks (that is, the local intensity maxima) of an image using a neighborhood analysis.
/// Warning: This command is experimental, his signature may be modified between now and his final version.
class IMAGEDEV_CPP_API PeakExtractor final : public GenericAlgorithm
{
public:
    /// The method for extracting the peaks.
    enum Method
    {
    /// Rough extraction of local maxima.
        FAST = 0,
    };

    // Command constructor.
    PeakExtractor();


    /// Gets the inputImage parameter.
    /// The input image from which the peaks must be extracted.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image from which the peaks must be extracted.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the numberOfPeaks parameter.
    /// The maximum number of peaks to extract. If this value is set to 0, all peaks having an intensity greater than or equal to the threshold vaue are detected.
    uint32_t numberOfPeaks() const;
    /// Sets the numberOfPeaks parameter.
    /// The maximum number of peaks to extract. If this value is set to 0, all peaks having an intensity greater than or equal to the threshold vaue are detected.
    void setNumberOfPeaks( const uint32_t& numberOfPeaks );

    /// Gets the threshold parameter.
    /// The threshold value that determines the minimal intensity of a selected peak.
    double threshold() const;
    /// Sets the threshold parameter.
    /// The threshold value that determines the minimal intensity of a selected peak.
    void setThreshold( const double& threshold );

    /// Gets the radius parameter.
    /// The minimum distance between two extracted peaks in pixels, along the X, Y, and Z directions
    iolink::Vector3u32 radius() const;
    /// Sets the radius parameter.
    /// The minimum distance between two extracted peaks in pixels, along the X, Y, and Z directions
    void setRadius( const iolink::Vector3u32& radius );

    /// Gets the method parameter.
    /// The method for extracting the peaks.
    PeakExtractor::Method method() const;
    /// Sets the method parameter.
    /// The method for extracting the peaks.
    void setMethod( const PeakExtractor::Method& method );

    /// Gets the outputMeasurement parameter.
    /// The result object containing the maxima positions and their associated intensity.
    PeakExtractorMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Extracts the peaks (that is, the local intensity maxima) of an image using a neighborhood analysis.
/// Warning: This command is experimental, his signature may be modified between now and his final version.
/// @param inputImage The input image from which the peaks must be extracted.
/// @param numberOfPeaks The maximum number of peaks to extract. If this value is set to 0, all peaks having an intensity greater than or equal to the threshold vaue are detected.
/// @param threshold The threshold value that determines the minimal intensity of a selected peak.
/// @param radius The minimum distance between two extracted peaks in pixels, along the X, Y, and Z directions
/// @param method The method for extracting the peaks.
/// @param outputMeasurement The result object containing the maxima positions and their associated intensity.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
PeakExtractorMsr::Ptr
peakExtractor( std::shared_ptr< iolink::ImageView > inputImage,
               uint32_t numberOfPeaks,
               double threshold,
               const iolink::Vector3u32& radius,
               PeakExtractor::Method method,
               PeakExtractorMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
