/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/ArrayX.h>
#include <memory>

namespace imagedev
{
/// Transforms an input 2D polyline into a new polygonal chain with line segments of constant length.
class IMAGEDEV_CPP_API PolylineResampler2d final : public GenericAlgorithm
{
public:
    /// The interpolation mode.
    enum InterpolationType
    {
    /// The vertices are linearly interpolated.
        LINEAR = 0,
    /// The vertices are computed with a cubic interpolation.
        CUBIC,
    /// The vertices are computed with a cubic interpolation using Paul Breeuwsma coefficients.
        CATMULL_ROM
    };

    // Command constructor.
    PolylineResampler2d();


    /// Gets the inputPolyline parameter.
    /// The input ArrayXd to resample.
    std::shared_ptr<iolink::ArrayXd> inputPolyline() const;
    /// Sets the inputPolyline parameter.
    /// The input ArrayXd to resample.
    void setInputPolyline( std::shared_ptr<iolink::ArrayXd> inputPolyline );

    /// Gets the spacing parameter.
    /// The spacing between each vertex of the output polyline.
    double spacing() const;
    /// Sets the spacing parameter.
    /// The spacing between each vertex of the output polyline.
    void setSpacing( const double& spacing );

    /// Gets the interpolationType parameter.
    /// The interpolation mode.
    PolylineResampler2d::InterpolationType interpolationType() const;
    /// Sets the interpolationType parameter.
    /// The interpolation mode.
    void setInterpolationType( const PolylineResampler2d::InterpolationType& interpolationType );

    /// Gets the outputPolyline parameter.
    /// The output resampled polyline.
    std::shared_ptr<iolink::ArrayXd> outputPolyline() const;
    /// Sets the outputPolyline parameter.
    /// The output resampled polyline.
    void setOutputPolyline( std::shared_ptr<iolink::ArrayXd> outputPolyline );

    // Method to launch the command.
    void execute();

};

/// Transforms an input 2D polyline into a new polygonal chain with line segments of constant length.
/// @param inputPolyline The input ArrayXd to resample.
/// @param spacing The spacing between each vertex of the output polyline.
/// @param interpolationType The interpolation mode.
/// @param outputPolyline The output resampled polyline.
/// @return Returns the outputPolyline output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr<iolink::ArrayXd>
polylineResampler2d( std::shared_ptr<iolink::ArrayXd> inputPolyline,
                     double spacing,
                     PolylineResampler2d::InterpolationType interpolationType,
                     std::shared_ptr<iolink::ArrayXd> outputPolyline = nullptr );
} // namespace imagedev
