/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Performs a three-dimensional gradient projection with a directional vector defined by a set of object centers of a label image.
class IMAGEDEV_CPP_API RadialGradientLabel3d final : public GenericAlgorithm
{
public:

    // Command constructor.
    RadialGradientLabel3d();


    /// Gets the inputImageX parameter.
    /// The X-gradient input image.
    std::shared_ptr< iolink::ImageView > inputImageX() const;
    /// Sets the inputImageX parameter.
    /// The X-gradient input image.
    void setInputImageX( std::shared_ptr< iolink::ImageView > inputImageX );

    /// Gets the inputImageY parameter.
    /// The Y-gradient input image.
    std::shared_ptr< iolink::ImageView > inputImageY() const;
    /// Sets the inputImageY parameter.
    /// The Y-gradient input image.
    void setInputImageY( std::shared_ptr< iolink::ImageView > inputImageY );

    /// Gets the inputImageZ parameter.
    /// The Z-gradient input image.
    std::shared_ptr< iolink::ImageView > inputImageZ() const;
    /// Sets the inputImageZ parameter.
    /// The Z-gradient input image.
    void setInputImageZ( std::shared_ptr< iolink::ImageView > inputImageZ );

    /// Gets the inputMarkerImage parameter.
    /// The marker input image of the label objects to consider as centers.
    std::shared_ptr< iolink::ImageView > inputMarkerImage() const;
    /// Sets the inputMarkerImage parameter.
    /// The marker input image of the label objects to consider as centers.
    void setInputMarkerImage( std::shared_ptr< iolink::ImageView > inputMarkerImage );

    /// Gets the outputNormalImage parameter.
    /// The normal gradient output image.
    std::shared_ptr< iolink::ImageView > outputNormalImage() const;
    /// Sets the outputNormalImage parameter.
    /// The normal gradient output image.
    void setOutputNormalImage( std::shared_ptr< iolink::ImageView > outputNormalImage );

    // Method to launch the command.
    void execute();

};

/// Performs a three-dimensional gradient projection with a directional vector defined by a set of object centers of a label image.
/// @param inputImageX The X-gradient input image.
/// @param inputImageY The Y-gradient input image.
/// @param inputImageZ The Z-gradient input image.
/// @param inputMarkerImage The marker input image of the label objects to consider as centers.
/// @param outputNormalImage The normal gradient output image.
/// @return Returns the outputNormalImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
radialGradientLabel3d( std::shared_ptr< iolink::ImageView > inputImageX,
                       std::shared_ptr< iolink::ImageView > inputImageY,
                       std::shared_ptr< iolink::ImageView > inputImageZ,
                       std::shared_ptr< iolink::ImageView > inputMarkerImage,
                       std::shared_ptr< iolink::ImageView > outputNormalImage = nullptr );
} // namespace imagedev
