/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/RadialIntensityProfileMsr.h>

namespace imagedev
{
/// Computes a radial intensity profile on a 2D image.
class IMAGEDEV_CPP_API RadialIntensityProfile2d final : public GenericAlgorithm
{
public:
    /// The way to define the origin of the radii.
    enum CenterMode
    {
    /// The origin of the radii is the center of the input image.
        IMAGE_CENTER = 0,
    /// The origin of the radii is user defined.
        OTHER
    };

    // Command constructor.
    RadialIntensityProfile2d();


    /// Gets the inputImage parameter.
    /// The input image. Any type of image is accepted.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image. Any type of image is accepted.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the centerMode parameter.
    /// The way to define the origin of the radii.
    RadialIntensityProfile2d::CenterMode centerMode() const;
    /// Sets the centerMode parameter.
    /// The way to define the origin of the radii.
    void setCenterMode( const RadialIntensityProfile2d::CenterMode& centerMode );

    /// Gets the center parameter.
    /// The origin of the radii in pixel coordinates. It is only used in OTHER mode.
    iolink::Vector2u32 center() const;
    /// Sets the center parameter.
    /// The origin of the radii in pixel coordinates. It is only used in OTHER mode.
    void setCenter( const iolink::Vector2u32& center );

    /// Gets the maximumRadius parameter.
    /// The radius in pixels up to which intensities are included in the profile.
    uint32_t maximumRadius() const;
    /// Sets the maximumRadius parameter.
    /// The radius in pixels up to which intensities are included in the profile.
    void setMaximumRadius( const uint32_t& maximumRadius );

    /// Gets the outputMeasurement parameter.
    /// The output object containing the computed radii, averaged intensities, and standard deviation.
    RadialIntensityProfileMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes a radial intensity profile on a 2D image.
/// @param inputImage The input image. Any type of image is accepted.
/// @param centerMode The way to define the origin of the radii.
/// @param center The origin of the radii in pixel coordinates. It is only used in OTHER mode.
/// @param maximumRadius The radius in pixels up to which intensities are included in the profile.
/// @param outputMeasurement The output object containing the computed radii, averaged intensities, and standard deviation.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
RadialIntensityProfileMsr::Ptr
radialIntensityProfile2d( std::shared_ptr< iolink::ImageView > inputImage,
                          RadialIntensityProfile2d::CenterMode centerMode,
                          const iolink::Vector2u32& center,
                          uint32_t maximumRadius,
                          RadialIntensityProfileMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
