/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Creates a new three-dimensional image with random values having an equidistribution.
class IMAGEDEV_CPP_API RandomImage3d final : public GenericAlgorithm
{
public:
    /// The output image data type.
    enum OutputType
    {
    /// The output image data type is 1 byte depth. Its possible intensities are unsigned integer from 0 to 255.
        UNSIGNED_INTEGER_8_BIT = 0,
    /// The output image data type is 1 byte depth. Its possible intensities are signed integer from -128 to 127.
        SIGNED_INTEGER_8_BIT,
    /// The output image data type is 2 bytes depth. Its possible intensities are signed integer from -32,768 to 32,767.
        SIGNED_INTEGER_16_BIT,
    /// The output image data type is 2 bytes depth. Its possible intensities are unsigned integer from 0 to 65,535.
        UNSIGNED_INTEGER_16_BIT,
    /// The output image data type is 2 bytes depth and interpretation is label. Its possible intensities are unsigned integer from 0 to 65,535.
        LABEL_16_BIT,
    /// The output image data type is 2 bytes depth and interpretation is binary. Its possible intensities are unsigned integer from 0 to 1.
        BINARY,
    /// The output image data type is 4 bytes depth. Its possible intensities are signed integer from -2,147,483,648 to 2,147,483,647.
        SIGNED_INTEGER_32_BIT,
    /// The output image data type is 4 bytes depth. Its possible intensities are unsigned floating-point from -3.402823E38 to 3.402823E38.
        FLOAT_32_BIT
    };

    // Command constructor.
    RandomImage3d();


    /// Gets the outputType parameter.
    /// The output image data type.
    RandomImage3d::OutputType outputType() const;
    /// Sets the outputType parameter.
    /// The output image data type.
    void setOutputType( const RandomImage3d::OutputType& outputType );

    /// Gets the imageSizeX parameter.
    /// The X size in pixels of the output image.
    int32_t imageSizeX() const;
    /// Sets the imageSizeX parameter.
    /// The X size in pixels of the output image.
    void setImageSizeX( const int32_t& imageSizeX );

    /// Gets the imageSizeY parameter.
    /// The Y size in pixels of the output image.
    int32_t imageSizeY() const;
    /// Sets the imageSizeY parameter.
    /// The Y size in pixels of the output image.
    void setImageSizeY( const int32_t& imageSizeY );

    /// Gets the imageSizeZ parameter.
    /// The Z size in pixels of the output image.
    int32_t imageSizeZ() const;
    /// Sets the imageSizeZ parameter.
    /// The Z size in pixels of the output image.
    void setImageSizeZ( const int32_t& imageSizeZ );

    /// Gets the mean parameter.
    /// The mean of random values.
    double mean() const;
    /// Sets the mean parameter.
    /// The mean of random values.
    void setMean( const double& mean );

    /// Gets the range parameter.
    /// The output intensity range of random values.
    double range() const;
    /// Sets the range parameter.
    /// The output intensity range of random values.
    void setRange( const double& range );

    /// Gets the outputImage parameter.
    /// The output image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Creates a new three-dimensional image with random values having an equidistribution.
/// @param outputType The output image data type.
/// @param imageSizeX The X size in pixels of the output image.
/// @param imageSizeY The Y size in pixels of the output image.
/// @param imageSizeZ The Z size in pixels of the output image.
/// @param mean The mean of random values.
/// @param range The output intensity range of random values.
/// @param outputImage The output image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
randomImage3d( RandomImage3d::OutputType outputType,
               int32_t imageSizeX,
               int32_t imageSizeY,
               int32_t imageSizeZ,
               double mean,
               double range,
               std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
