/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// ReconstructionFromMarkers3d rebuilds a binary image starting from markers.
class IMAGEDEV_CPP_API ReconstructionFromMarkers3d final : public GenericAlgorithm
{
public:
    /// The 3D neighborhood configuration.
    enum Neighborhood
    {
    /// The structuring element is composed of voxels with a common face with the voxel of interest.
        CONNECTIVITY_6 = 0,
    /// The structuring element is composed of voxels with at least one common edge.
        CONNECTIVITY_18,
    /// The structuring element is a full cube.
        CONNECTIVITY_26
    };

    // Command constructor.
    ReconstructionFromMarkers3d();


    /// Gets the inputImage parameter.
    /// The binary mask image constraining reconstruction.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The binary mask image constraining reconstruction.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the inputMarkerImage parameter.
    /// The binary marker image containing seeds for reconstruction. It must have the same dimensions and type as the input image.
    std::shared_ptr< iolink::ImageView > inputMarkerImage() const;
    /// Sets the inputMarkerImage parameter.
    /// The binary marker image containing seeds for reconstruction. It must have the same dimensions and type as the input image.
    void setInputMarkerImage( std::shared_ptr< iolink::ImageView > inputMarkerImage );

    /// Gets the neighborhood parameter.
    /// The 3D neighborhood configuration.
    ReconstructionFromMarkers3d::Neighborhood neighborhood() const;
    /// Sets the neighborhood parameter.
    /// The 3D neighborhood configuration.
    void setNeighborhood( const ReconstructionFromMarkers3d::Neighborhood& neighborhood );

    /// Gets the outputImage parameter.
    /// The binary output image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The binary output image. Its dimensions and type are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// ReconstructionFromMarkers3d rebuilds a binary image starting from markers.
/// @param inputImage The binary mask image constraining reconstruction.
/// @param inputMarkerImage The binary marker image containing seeds for reconstruction. It must have the same dimensions and type as the input image.
/// @param neighborhood The 3D neighborhood configuration.
/// @param outputImage The binary output image. Its dimensions and type are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
reconstructionFromMarkers3d( std::shared_ptr< iolink::ImageView > inputImage,
                             std::shared_ptr< iolink::ImageView > inputMarkerImage,
                             ReconstructionFromMarkers3d::Neighborhood neighborhood,
                             std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
