/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/RegionSimilarityMsr.h>

namespace imagedev
{
/// Computes similarity values between the regions from two label images.
class IMAGEDEV_CPP_API RegionSimilarity final : public GenericAlgorithm
{
public:

    // Command constructor.
    RegionSimilarity();


    /// Gets the inputLabelImage parameter.
    /// The segmented image to assess.
    std::shared_ptr< iolink::ImageView > inputLabelImage() const;
    /// Sets the inputLabelImage parameter.
    /// The segmented image to assess.
    void setInputLabelImage( std::shared_ptr< iolink::ImageView > inputLabelImage );

    /// Gets the inputReferenceImage parameter.
    /// The ground truth image. This image must have same dimensions and type as the main input image.
    std::shared_ptr< iolink::ImageView > inputReferenceImage() const;
    /// Sets the inputReferenceImage parameter.
    /// The ground truth image. This image must have same dimensions and type as the main input image.
    void setInputReferenceImage( std::shared_ptr< iolink::ImageView > inputReferenceImage );

    /// Gets the outputMeasurement parameter.
    /// The similarity results.
    RegionSimilarityMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes similarity values between the regions from two label images.
/// @param inputLabelImage The segmented image to assess.
/// @param inputReferenceImage The ground truth image. This image must have same dimensions and type as the main input image.
/// @param outputMeasurement The similarity results.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
RegionSimilarityMsr::Ptr
regionSimilarity( std::shared_ptr< iolink::ImageView > inputLabelImage,
                  std::shared_ptr< iolink::ImageView > inputReferenceImage,
                  RegionSimilarityMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
