/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Utilities/Deprecation.h>

namespace imagedev
{
/// Rescales the dimensions of a two-dimensional or three-dimensional image.
class IMAGEDEV_CPP_API RescaleImageByFactor final : public GenericAlgorithm
{
public:
    /// The interpolation mode. Method used to calculate the intensity of each pixel in the result image.
    enum InterpolationType
    {
    /// Assign the gray level of the nearest pixel.
        NEAREST_NEIGHBOR = 0,
    /// Assign the bilinear interpolation from the four nearest pixels.
        LINEAR,
    /// Assign the cubic interpolation from the nearest pixels.
        SPLINE
    };

    // Command constructor.
    IMAGEDEV_DEPRECATED( "This command is deprecated, it will be removed in ImageDev 2026.1. You can use RescaleByFactor instead.") RescaleImageByFactor();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the scaleFactor parameter.
    /// The zoom factor.
    double scaleFactor() const;
    /// Sets the scaleFactor parameter.
    /// The zoom factor.
    void setScaleFactor( const double& scaleFactor );

    /// Gets the interpolationType parameter.
    /// The interpolation mode. Method used to calculate the intensity of each pixel in the result image.
    RescaleImageByFactor::InterpolationType interpolationType() const;
    /// Sets the interpolationType parameter.
    /// The interpolation mode. Method used to calculate the intensity of each pixel in the result image.
    void setInterpolationType( const RescaleImageByFactor::InterpolationType& interpolationType );

    /// Gets the outputImage parameter.
    /// The output image. Its type is forced to the same value as the input. Its dimensions depend on the scale factor parameter.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its type is forced to the same value as the input. Its dimensions depend on the scale factor parameter.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Rescales the dimensions of a two-dimensional or three-dimensional image.
/// @param inputImage The input image.
/// @param scaleFactor The zoom factor.
/// @param interpolationType The interpolation mode. Method used to calculate the intensity of each pixel in the result image.
/// @param outputImage The output image. Its type is forced to the same value as the input. Its dimensions depend on the scale factor parameter.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
rescaleImageByFactor( std::shared_ptr< iolink::ImageView > inputImage,
                      double scaleFactor,
                      RescaleImageByFactor::InterpolationType interpolationType,
                      std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
