/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Restores a microscopy image with the Richardson-Lucy deconvolution.
/// Warning: This command is experimental, his signature may be modified between now and his final version.
class IMAGEDEV_CPP_API RichardsonLucyDeconvolution final : public GenericAlgorithm
{
public:
    /// The initial estimate of the deconvolution algorithm. If CONSTANT is chosen, a constant image is used initially.  Often, this yields smoother results than the second option, namely input data.
    enum InitialEstimate
    {
    /// Use a constant image as the initial estimate.
        CONSTANT = 0,
    /// Use the input image as the initial estimate.
        INPUT_IMAGE
    };
    /// The algorithm implementation used to perform the convolution.
    enum FilterMode
    {
    /// The computation is performed applying a classic sliding window. Using this mode can provide a faster computation time, for small kernel image size.
        SPATIAL = 0,
    /// The computation is performed by a multiplication in the Fourier domain.  Using this mode provides a constant computation time, independent from the kernel image size.
        FREQUENCY
    };

    // Command constructor.
    RichardsonLucyDeconvolution();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the inputPsfImage parameter.
    /// The point spread function (PSF) that models the degradation filter. The PSF is passed as an image.
    std::shared_ptr< iolink::ImageView > inputPsfImage() const;
    /// Sets the inputPsfImage parameter.
    /// The point spread function (PSF) that models the degradation filter. The PSF is passed as an image.
    void setInputPsfImage( std::shared_ptr< iolink::ImageView > inputPsfImage );

    /// Gets the numberOfIterations parameter.
    /// The number of iterations performed.
    uint32_t numberOfIterations() const;
    /// Sets the numberOfIterations parameter.
    /// The number of iterations performed.
    void setNumberOfIterations( const uint32_t& numberOfIterations );

    /// Gets the initialEstimate parameter.
    /// The initial estimate of the deconvolution algorithm. If CONSTANT is chosen, a constant image is used initially.  Often, this yields smoother results than the second option, namely input data.
    RichardsonLucyDeconvolution::InitialEstimate initialEstimate() const;
    /// Sets the initialEstimate parameter.
    /// The initial estimate of the deconvolution algorithm. If CONSTANT is chosen, a constant image is used initially.  Often, this yields smoother results than the second option, namely input data.
    void setInitialEstimate( const RichardsonLucyDeconvolution::InitialEstimate& initialEstimate );

    /// Gets the filterMode parameter.
    /// The algorithm implementation used to perform the convolution.
    RichardsonLucyDeconvolution::FilterMode filterMode() const;
    /// Sets the filterMode parameter.
    /// The algorithm implementation used to perform the convolution.
    void setFilterMode( const RichardsonLucyDeconvolution::FilterMode& filterMode );

    /// Gets the outputImage parameter.
    /// The output image. The output image characteristics are forced to the same as the input image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. The output image characteristics are forced to the same as the input image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Restores a microscopy image with the Richardson-Lucy deconvolution.
/// Warning: This command is experimental, his signature may be modified between now and his final version.
/// @param inputImage The input image.
/// @param inputPsfImage The point spread function (PSF) that models the degradation filter. The PSF is passed as an image.
/// @param numberOfIterations The number of iterations performed.
/// @param initialEstimate The initial estimate of the deconvolution algorithm. If CONSTANT is chosen, a constant image is used initially.  Often, this yields smoother results than the second option, namely input data.
/// @param filterMode The algorithm implementation used to perform the convolution.
/// @param outputImage The output image. The output image characteristics are forced to the same as the input image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
richardsonLucyDeconvolution( std::shared_ptr< iolink::ImageView > inputImage,
                             std::shared_ptr< iolink::ImageView > inputPsfImage,
                             uint32_t numberOfIterations,
                             RichardsonLucyDeconvolution::InitialEstimate initialEstimate,
                             RichardsonLucyDeconvolution::FilterMode filterMode,
                             std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
