/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Opens objects of a three-dimensional binary image conditionally to a local constraint.
class IMAGEDEV_CPP_API SelectiveOpening3d final : public GenericAlgorithm
{
public:

    // Command constructor.
    SelectiveOpening3d();


    /// Gets the inputBinaryImage parameter.
    /// The binary input image.
    std::shared_ptr< iolink::ImageView > inputBinaryImage() const;
    /// Sets the inputBinaryImage parameter.
    /// The binary input image.
    void setInputBinaryImage( std::shared_ptr< iolink::ImageView > inputBinaryImage );

    /// Gets the numberOfIterations parameter.
    /// The number of iterations.
    uint32_t numberOfIterations() const;
    /// Sets the numberOfIterations parameter.
    /// The number of iterations.
    void setNumberOfIterations( const uint32_t& numberOfIterations );

    /// Gets the threshold parameter.
    /// The minimum number of neighbors that is required to transform a pixel.
    uint32_t threshold() const;
    /// Sets the threshold parameter.
    /// The minimum number of neighbors that is required to transform a pixel.
    void setThreshold( const uint32_t& threshold );

    /// Gets the outputBinaryImage parameter.
    /// The binary output image. Its size and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The binary output image. Its size and type are forced to the same values as the input.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Opens objects of a three-dimensional binary image conditionally to a local constraint.
/// @param inputBinaryImage The binary input image.
/// @param numberOfIterations The number of iterations.
/// @param threshold The minimum number of neighbors that is required to transform a pixel.
/// @param outputBinaryImage The binary output image. Its size and type are forced to the same values as the input.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
selectiveOpening3d( std::shared_ptr< iolink::ImageView > inputBinaryImage,
                    uint32_t numberOfIterations,
                    uint32_t threshold,
                    std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
