/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Converts a sequence input into a spectral image.
class IMAGEDEV_CPP_API SequenceToMultispectral final : public GenericAlgorithm
{
public:

    // Command constructor.
    SequenceToMultispectral();


    /// Gets the inputSequence parameter.
    /// The input sequence of type IMAGE_SEQUENCE or VOLUME_SEQUENCE.
    std::shared_ptr< iolink::ImageView > inputSequence() const;
    /// Sets the inputSequence parameter.
    /// The input sequence of type IMAGE_SEQUENCE or VOLUME_SEQUENCE.
    void setInputSequence( std::shared_ptr< iolink::ImageView > inputSequence );

    /// Gets the outputSpectralImage parameter.
    /// The output image of type MULTISPECTRAL_IMAGE or MULTISPECTRAL_VOLUME. Its spatial dimensions  and type are forced to the same values as the input. Its number of channels is equal to the  sequence dimension of the input.
    std::shared_ptr< iolink::ImageView > outputSpectralImage() const;
    /// Sets the outputSpectralImage parameter.
    /// The output image of type MULTISPECTRAL_IMAGE or MULTISPECTRAL_VOLUME. Its spatial dimensions  and type are forced to the same values as the input. Its number of channels is equal to the  sequence dimension of the input.
    void setOutputSpectralImage( std::shared_ptr< iolink::ImageView > outputSpectralImage );

    // Method to launch the command.
    void execute();

};

/// Converts a sequence input into a spectral image.
/// @param inputSequence The input sequence of type IMAGE_SEQUENCE or VOLUME_SEQUENCE.
/// @param outputSpectralImage The output image of type MULTISPECTRAL_IMAGE or MULTISPECTRAL_VOLUME. Its spatial dimensions  and type are forced to the same values as the input. Its number of channels is equal to the  sequence dimension of the input.
/// @return Returns the outputSpectralImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
sequenceToMultispectral( std::shared_ptr< iolink::ImageView > inputSequence, std::shared_ptr< iolink::ImageView > outputSpectralImage = nullptr );
} // namespace imagedev
