/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/Model/TextureClassificationModel.h>

namespace imagedev
{
/// Enriches a texture model by training it on a gray level image that has been labeled.
class IMAGEDEV_CPP_API TextureClassificationTrain final : public GenericAlgorithm
{
public:

    // Command constructor.
    TextureClassificationTrain();


    /// Gets the inputImage parameter.
    /// The input grayscale image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input grayscale image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the inputTrainingImage parameter.
    /// The input label image.
    std::shared_ptr< iolink::ImageView > inputTrainingImage() const;
    /// Sets the inputTrainingImage parameter.
    /// The input label image.
    void setInputTrainingImage( std::shared_ptr< iolink::ImageView > inputTrainingImage );

    /// Gets the minSeparationPercentage parameter.
    /// This parameter controls the rejection criteria of the feature selection algorithm (FS).
    double minSeparationPercentage() const;
    /// Sets the minSeparationPercentage parameter.
    /// This parameter controls the rejection criteria of the feature selection algorithm (FS).
    void setMinSeparationPercentage( const double& minSeparationPercentage );

    /// Gets the finalizeTraining parameter.
    /// This parameter indicates whether the algorithm must finalize the training. This parameter must be set to true since the retraining is currently not allowed.
    bool finalizeTraining() const;
    /// Sets the finalizeTraining parameter.
    /// This parameter indicates whether the algorithm must finalize the training. This parameter must be set to true since the retraining is currently not allowed.
    void setFinalizeTraining( const bool& finalizeTraining );

    /// Gets the inputOutputModel parameter.
    /// The input and output texture classification model.
    TextureClassificationModel::Ptr inputOutputModel() const;
    /// Sets the inputOutputModel parameter.
    /// The input and output texture classification model.
    void setInputOutputModel( TextureClassificationModel::Ptr inputOutputModel );

    // Method to launch the command.
    void execute();

};

/// Enriches a texture model by training it on a gray level image that has been labeled.
/// @param inputImage The input grayscale image.
/// @param inputTrainingImage The input label image.
/// @param minSeparationPercentage This parameter controls the rejection criteria of the feature selection algorithm (FS).
/// @param finalizeTraining This parameter indicates whether the algorithm must finalize the training. This parameter must be set to true since the retraining is currently not allowed.
/// @param inputOutputModel The input and output texture classification model.
/// @return Returns the inputOutputModel output parameter.
IMAGEDEV_CPP_API 
TextureClassificationModel::Ptr
textureClassificationTrain( std::shared_ptr< iolink::ImageView > inputImage,
                            std::shared_ptr< iolink::ImageView > inputTrainingImage,
                            double minSeparationPercentage,
                            bool finalizeTraining,
                            TextureClassificationModel::Ptr inputOutputModel = nullptr );
} // namespace imagedev
