/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Performs a criterion based thresholding on a grayscale image.
class IMAGEDEV_CPP_API ThresholdingByCriterion final : public GenericAlgorithm
{
public:
    /// The criterion of comparison.
    enum ComparisonCriterion
    {
    /// Pixels having a value less than the comparison value are set to 1, others are set to 0.
        LESS_THAN = 0,
    /// Pixels having a value less than or equal to the comparison value are set to 1, others are set to 0.
        LESS_THAN_OR_EQUAL_TO,
    /// Pixels having a value equal to the comparison value are set to 1, others are set to 0.
        EQUAL_TO,
    /// Pixels having a value greater than or equal to the comparison value are set to 1, others are set to 0.
        GREATER_THAN_OR_EQUAL_TO,
    /// Pixels having a value greater than the comparison value are set to 1, others are set to 0.
        GREATER_THAN,
    /// Pixels having a value different from the comparison value are set to 1, others are set to 0.
        NOT_EQUAL_TO
    };

    // Command constructor.
    ThresholdingByCriterion();


    /// Gets the inputGrayImage parameter.
    /// Input gray level image.
    std::shared_ptr< iolink::ImageView > inputGrayImage() const;
    /// Sets the inputGrayImage parameter.
    /// Input gray level image.
    void setInputGrayImage( std::shared_ptr< iolink::ImageView > inputGrayImage );

    /// Gets the comparisonCriterion parameter.
    /// The criterion of comparison.
    ThresholdingByCriterion::ComparisonCriterion comparisonCriterion() const;
    /// Sets the comparisonCriterion parameter.
    /// The criterion of comparison.
    void setComparisonCriterion( const ThresholdingByCriterion::ComparisonCriterion& comparisonCriterion );

    /// Gets the comparisonValue parameter.
    /// The threshold level.
    double comparisonValue() const;
    /// Sets the comparisonValue parameter.
    /// The threshold level.
    void setComparisonValue( const double& comparisonValue );

    /// Gets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Performs a criterion based thresholding on a grayscale image.
/// @param inputGrayImage Input gray level image.
/// @param comparisonCriterion The criterion of comparison.
/// @param comparisonValue The threshold level.
/// @param outputBinaryImage The output binary image. Its dimensions are forced to the same values as the input.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
thresholdingByCriterion( std::shared_ptr< iolink::ImageView > inputGrayImage,
                         ThresholdingByCriterion::ComparisonCriterion comparisonCriterion,
                         double comparisonValue,
                         std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
