/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Computes the amplitude of a 3D vector such as a gradient from its X, Y, and Z components.
class IMAGEDEV_CPP_API VectorToMagnitude3d final : public GenericAlgorithm
{
public:
    /// The output mode.
    enum OutputType
    {
    /// This option computes the amplitude as the maximum between X, Y, and Z components.
        AMPLITUDE_MAXIMUM = 0,
    /// This option computes the Euclidean norm of the vector.
        AMPLITUDE_EUCLIDEAN
    };

    // Command constructor.
    VectorToMagnitude3d();


    /// Gets the inputImageX parameter.
    /// The X vector component input image.
    std::shared_ptr< iolink::ImageView > inputImageX() const;
    /// Sets the inputImageX parameter.
    /// The X vector component input image.
    void setInputImageX( std::shared_ptr< iolink::ImageView > inputImageX );

    /// Gets the inputImageY parameter.
    /// The Y vector component input image.
    std::shared_ptr< iolink::ImageView > inputImageY() const;
    /// Sets the inputImageY parameter.
    /// The Y vector component input image.
    void setInputImageY( std::shared_ptr< iolink::ImageView > inputImageY );

    /// Gets the inputImageZ parameter.
    /// The Z vector component input image.
    std::shared_ptr< iolink::ImageView > inputImageZ() const;
    /// Sets the inputImageZ parameter.
    /// The Z vector component input image.
    void setInputImageZ( std::shared_ptr< iolink::ImageView > inputImageZ );

    /// Gets the outputType parameter.
    /// The output mode.
    VectorToMagnitude3d::OutputType outputType() const;
    /// Sets the outputType parameter.
    /// The output mode.
    void setOutputType( const VectorToMagnitude3d::OutputType& outputType );

    /// Gets the outputAmplitudeImage parameter.
    /// The gradient amplitude output image.
    std::shared_ptr< iolink::ImageView > outputAmplitudeImage() const;
    /// Sets the outputAmplitudeImage parameter.
    /// The gradient amplitude output image.
    void setOutputAmplitudeImage( std::shared_ptr< iolink::ImageView > outputAmplitudeImage );

    // Method to launch the command.
    void execute();

};

/// Computes the amplitude of a 3D vector such as a gradient from its X, Y, and Z components.
/// @param inputImageX The X vector component input image.
/// @param inputImageY The Y vector component input image.
/// @param inputImageZ The Z vector component input image.
/// @param outputType The output mode.
/// @param outputAmplitudeImage The gradient amplitude output image.
/// @return Returns the outputAmplitudeImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
vectorToMagnitude3d( std::shared_ptr< iolink::ImageView > inputImageX,
                     std::shared_ptr< iolink::ImageView > inputImageY,
                     std::shared_ptr< iolink::ImageView > inputImageZ,
                     VectorToMagnitude3d::OutputType outputType,
                     std::shared_ptr< iolink::ImageView > outputAmplitudeImage = nullptr );
} // namespace imagedev
