/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>

#include <string>

#include <functional>

namespace imagedev {

class GenericAlgorithm;

typedef std::function< void( const GenericAlgorithm& algorithm, const std::string& progressMessage ) >
    ProgressMessageCallback;

// Set a callback to receive text progression message from ImageDev algorithms
IMAGEDEV_CPP_API void setProgressMessageCallback( ProgressMessageCallback progressMessageCallback );

// Get the callback to receive text progression message from ImageDev algorithms
IMAGEDEV_CPP_API ProgressMessageCallback getProgressMessageCallback();

typedef std::function< void( const GenericAlgorithm& algorithm, float progressRatio ) > ProgressRatioCallback;

// Set a callback to track the progression ratio of ImageDev algorithms
IMAGEDEV_CPP_API void setProgressRatioCallback( ProgressRatioCallback progressRatioCallback );

// Get the callback to track the progression ratio of ImageDev algorithms
IMAGEDEV_CPP_API ProgressRatioCallback getProgressRatioCallback();

typedef std::function< bool( const GenericAlgorithm& ) > CancellationCallback;

// Set a callback that offers the opportunity to cancel the running algorithms by returning true.
IMAGEDEV_CPP_API void setCancellationCallback( CancellationCallback cancellationCallback );

// Get the callback that offers the opportunity to cancel the running algorithms by returning true.
IMAGEDEV_CPP_API CancellationCallback getCancellationCallback();

typedef std::function<
    void( const GenericAlgorithm& algorithm, const std::string& progressData, const std::string& dataEncoding ) >
    ProgressDataCallback;

// Set a callback to receive progression data from ImageDev algorithms
IMAGEDEV_CPP_API void setProgressDataCallback( ProgressDataCallback progressDataCallback );

// Get the callback to receive progression Data from ImageDev algorithms
IMAGEDEV_CPP_API ProgressDataCallback getProgressDataCallback();

// Enables or disable the verbose mode.
IMAGEDEV_CPP_API void setVerbose( bool enable );

// Returns whether or not the verbose mode is enable.
IMAGEDEV_CPP_API bool getVerbose();

// set the number of cpu used by algorithms.
IMAGEDEV_CPP_API void setCpuNumber( int cpuNumber );

// Returns the number of cpu used by algorithms.
IMAGEDEV_CPP_API int getCpuNumber();

} // namespace imagedev

#include <ImageDev/Processing/GenericAlgorithm.h>
