// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <iolink/IOLinkAPI.h>

namespace iolink
{

/**
 * The level of logs to display.
 *
 * When a level is activated, all levels above will
 * be displayed too.
 *
 * Example: activating WARNING level will display
 * CRITICAL, ERROR, and WARNING logs.
 */
enum class LogLevel
{
  /** No logging at all */
  LOG_OFF,

  /** Severe errors that cause premature termination. */
  LOG_CRITICAL,

  /** Runtime errors or unexpected conditions. */
  LOG_ERR,

  /**
   * Use of deprecated APIs, poor use of API, 'almost'
   * errors, other runtime situations that are undesirable
   * or unexpected, but not necessarily "wrong".
   */
  LOG_WARNING,

  /**
   * Interesting runtime events (startup/shutdown).
   */
  LOG_INFO,

  /** Detailed information on the flow through the system. */
  LOG_DEBUG,

  /**
   * Only for "tracing" the code and trying to find one
   * part of a function specifically
   */
  LOG_TRACE,
};

/**
 * Manage IOLink logging.
 *
 * The logging system will be initialized automatically, using
 * the WARNING level in release and DEBUG level in debug.
 * You can force the log level using init before any call to
 * IOLink. If you call it after, the logging system will already
 * be initialized, and your call will have no effect.
 */
class IOLINK_API Logger
{
public:
  /**
   * Forces initialization of the logging system with
   * a given log level.
   *
   * This should be called before any call to IOLink.
   *
   * @param level The desired log level.
   *
   * @warning If the logging system is already initialized,
   *          its log level will not be changed.
   */
  static void init(LogLevel level);

  /**
   * Return the log level of the logging system.
   */
  static LogLevel logLevel();
};

} // end namespace iolink
