/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

#include <ImageDev/Data/AnalysisMeasurements/AnalysisMsrType.h>

#include <ImageDev/Data/MeasurementInformation/CustomMeasurementInfo.h>
namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct AnalysisMsrPrivate;

/// Defines the measurements to compute in analysis algorithms and gives access to their results.
class IMAGEDEV_CPP_API AnalysisMsr
{
public:
    typedef AnalysisMsr Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default constructor
    AnalysisMsr();
    /// Default destructor
    ~AnalysisMsr();

    /// Writes the AnalysisMsr measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the AnalysisMsr measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The AnalysisMsr measurement read.
    static AnalysisMsr::Ptr read( const std::string& pathName );

    /// Gets the information of a measurement from its name.
    static const MsrInfo* getMeasurementInfoFromName( const std::string& name );

    /// Selects a specific measurement to be computed by an image analysis processing algorithm.
    void select( const MsrInfo* info );

    /// Selects a list of measurements to be computed by an image analysis processing algorithm.
    void select( std::vector< const MsrInfo* > infos );

    /// Selects a specific measurement to be computed by an image analysis processing algorithm.
    template< typename TInfo >
    std::shared_ptr< typename AnalysisMsrType< TInfo >::type > select( const TInfo* info );

    /// Returns the measurement corresponding to the given MsrInfo object.
    template< typename TInfo >
    std::shared_ptr< typename AnalysisMsrType< TInfo >::type > get( const TInfo* info );

    /// Gets the list of all measurements.
    /// @return The list of all measurements.
    std::vector< measurements::Measurement::Ptr > getMeasurements() const;

    /// Returns the number of label.
    uint64_t labelCount() const;

    /// Convert the analysis into an iolink DataFrame.
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Adds a custom measurement to the current ImageDev instance.
    static const CustomMeasurementInfo* registerCustomMeasurement(
        const std::string& name,
        const std::string& formula,
        const std::string& description,
        const imagedev::PhysicalInformation physicalInformation = imagedev::PhysicalInformation::UNKNOWN );
    /// Removes a custom measurement from the current ImageDev instance.
    static void unregisterCustomMeasurement( const std::string& name );
    /// Checks if a measurement exists.
    static bool exists( const std::string& name );

private:
    friend struct AnalysisMsrPrivate;
    AnalysisMsr( object_model::DynamicDictionary* );
    AnalysisMsrPrivate* m_p;
};

} // namespace imagedev
