/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Data/MeasurementInformation/MsrInfo.h>
#include <ImageDev/ImageDevCppExports.h>
#include <memory>
#include <vector>

namespace imagedev {

struct MeasurementGroupPrivate;

/// This class allows the creation of serializable object containing a set of features.
class IMAGEDEV_CPP_API MeasurementGroup
{
public:
    typedef std::shared_ptr< MeasurementGroup > Ptr;

    /// Default constructor
    MeasurementGroup();
    /// Constructor from a predefined list of measurements.
    MeasurementGroup( std::vector< const MsrInfo* > msrInfos );
    /// Destructor
    ~MeasurementGroup();

    /// Adds a measurement into the MeasurementGroup object.
    void add( const MsrInfo* msrInfo );
    /// Adds a list of measurements into the MeasurementGroup object.
    void add( const std::vector< const MsrInfo* >& msrInfos );

    /// Removes a measurement from the MeasurementGroup object.
    void remove( const MsrInfo* msrInfo );
    /// Removes a list of measurements from the MeasurementGroup object.
    void remove( const std::vector< const MsrInfo* >& msrInfos );

    /// Reads the MeasurementGroup object from a file path.
    void read( const std::string& pathFile );
    /// Writes the MeasurementGroup object into a file defined by a path.
    void write( const std::string& pathFile, bool overWrite = true ) const;

    /// Gets the list of measurements embedded in the MeasurementGroup object.
    std::vector< const MsrInfo* > getMeasurements() const;

private:
    friend struct MeasurementGroupPrivate;
    // private impl
    MeasurementGroupPrivate* m_p;
};

} // namespace imagedev
