/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct CrossCorrelation2dMsrPrivate;

/// Contains the position of the main correlation peak detected in an image.
/// This object is generated by the imagedev::CrossCorrelation2d algorithm and the imagedev::crossCorrelation2d function.
class IMAGEDEV_CPP_API CrossCorrelation2dMsr
{
public:
    typedef CrossCorrelation2dMsr Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default destructor
    ~CrossCorrelation2dMsr();

    /// Writes the CrossCorrelation2dMsr measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the CrossCorrelation2dMsr measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The CrossCorrelation2dMsr measurement read.
    static CrossCorrelation2dMsr::Ptr read( const std::string& pathName );

    /// Returns the size of the measurement
    int64_t size() const;

    /// Converts the measurement to an IOLink.DataFrame
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Gets a result of the matchingPositionX measurement.
    uint64_t matchingPositionX( size_t sliceIndex = 0 ) const;
    const FieldInformation & matchingPositionXInformation() const;

    /// Gets a result of the matchingPositionY measurement.
    uint64_t matchingPositionY( size_t sliceIndex = 0 ) const;
    const FieldInformation & matchingPositionYInformation() const;

    /// Gets a result of the maxComputed measurement.
    double maxComputed( size_t sliceIndex = 0 ) const;
    const FieldInformation & maxComputedInformation() const;

    /// Gets a result of the minComputed measurement.
    double minComputed( size_t sliceIndex = 0 ) const;
    const FieldInformation & minComputedInformation() const;

private:
    friend struct CrossCorrelation2dMsrPrivate;
    CrossCorrelation2dMsr( object_model::Dictionary* );
    CrossCorrelation2dMsrPrivate* m_p;
};

} // namespace imagedev
