/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct IntensityIntegral3dMsrPrivate;

/// Contains information related to summing the voxel intensities of a three-dimensional image.
/// This object is generated by the imagedev::IntensityIntegral3d algorithm and the imagedev::intensityIntegral3d function.
class IMAGEDEV_CPP_API IntensityIntegral3dMsr
{
public:
    typedef IntensityIntegral3dMsr Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default destructor
    ~IntensityIntegral3dMsr();

    /// Writes the IntensityIntegral3dMsr measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the IntensityIntegral3dMsr measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The IntensityIntegral3dMsr measurement read.
    static IntensityIntegral3dMsr::Ptr read( const std::string& pathName );

    /// Returns the size of the measurement
    int64_t size() const;

    /// Converts the measurement to an IOLink.DataFrame
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Gets a result of the intensityIntegral measurement.
    double intensityIntegral(  ) const;
    const FieldInformation & intensityIntegralInformation() const;

    /// Gets a result of the volumeFraction measurement.
    double volumeFraction(  ) const;
    const FieldInformation & volumeFractionInformation() const;

private:
    friend struct IntensityIntegral3dMsrPrivate;
    IntensityIntegral3dMsr( object_model::Dictionary* );
    IntensityIntegral3dMsrPrivate* m_p;
};

} // namespace imagedev
