/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/ImageDevCppExports.h>
#include <iolink/Vector.h>
#include <iolink/view/DataFrameView.h>
#include <ImageDev/Data/MeasurementInformation/FieldInformation.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <memory>
#include <vector>

namespace object_model
{
class Dictionary;
}

namespace imagedev
{
struct SegmentationMetricsObjectMsrPrivate;

/// Contains classical quality metrics for assessing the quality of a segmentation per label relative to a ground truth.
/// This object is generated by the imagedev::SegmentationMetricsObject algorithm and the imagedev::segmentationMetricsObject function.
class IMAGEDEV_CPP_API SegmentationMetricsObjectMsr
{
public:
    typedef SegmentationMetricsObjectMsr Self;
    typedef std::shared_ptr< Self > Ptr;

    /// Default destructor
    ~SegmentationMetricsObjectMsr();

    /// Writes the SegmentationMetricsObjectMsr measurement into a file defined by a path.
    /// @param pathName Path of a file
    void write( const std::string& pathName ) const;
    /// Reads the SegmentationMetricsObjectMsr measurement from a file defined by a path.
    /// @param pathName Path of a file
    /// @return The SegmentationMetricsObjectMsr measurement read.
    static SegmentationMetricsObjectMsr::Ptr read( const std::string& pathName );

    /// Returns the size of the measurement
    const iolink::Vector2i64& size() const;

    /// Converts the measurement to an IOLink.DataFrame
    std::shared_ptr< iolink::DataFrameView > toDataFrame() const;

    /// Gets a result of the accuracy measurement.
    double accuracy( size_t time = 0, size_t label = 0 ) const;
    const FieldInformation & accuracyInformation() const;

    /// Gets a result of the dice measurement.
    double dice( size_t time = 0, size_t label = 0 ) const;
    const FieldInformation & diceInformation() const;

    /// Gets a result of the falseNegative measurement.
    uint64_t falseNegative( size_t time = 0, size_t label = 0 ) const;
    const FieldInformation & falseNegativeInformation() const;

    /// Gets a result of the falsePositive measurement.
    uint64_t falsePositive( size_t time = 0, size_t label = 0 ) const;
    const FieldInformation & falsePositiveInformation() const;

    /// Gets a result of the jaccard measurement.
    double jaccard( size_t time = 0, size_t label = 0 ) const;
    const FieldInformation & jaccardInformation() const;

    /// Gets a result of the labelValue measurement.
    uint64_t labelValue( size_t time = 0, size_t label = 0 ) const;
    const FieldInformation & labelValueInformation() const;

    /// Gets a result of the precision measurement.
    double precision( size_t time = 0, size_t label = 0 ) const;
    const FieldInformation & precisionInformation() const;

    /// Gets a result of the sensitivity measurement.
    double sensitivity( size_t time = 0, size_t label = 0 ) const;
    const FieldInformation & sensitivityInformation() const;

    /// Gets a result of the specificity measurement.
    double specificity( size_t time = 0, size_t label = 0 ) const;
    const FieldInformation & specificityInformation() const;

    /// Gets a result of the trueNegative measurement.
    uint64_t trueNegative( size_t time = 0, size_t label = 0 ) const;
    const FieldInformation & trueNegativeInformation() const;

    /// Gets a result of the truePositive measurement.
    uint64_t truePositive( size_t time = 0, size_t label = 0 ) const;
    const FieldInformation & truePositiveInformation() const;

private:
    friend struct SegmentationMetricsObjectMsrPrivate;
    SegmentationMetricsObjectMsr( object_model::Dictionary* );
    SegmentationMetricsObjectMsrPrivate* m_p;
};

} // namespace imagedev
