/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once
#include <ImageDev/Data/AnalysisMeasurements/Measurement.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalDimension.h>
#include <ImageDev/Data/MeasurementInformation/PhysicalInformation.h>
#include <ImageDev/ImageDevCppExports.h>

#include <memory>
#include <string>
#include <vector>
#pragma warning( push )
#pragma warning( disable : 4251 )

struct MsrInfoImpl;

namespace imagedev {

/// The MsrInfo object contains the name and the physical dimension of a measurement.
class IMAGEDEV_CPP_API MsrInfo
{
public:
    /// Internal constructor
    MsrInfo( MsrInfoImpl* impl );

    /// Destructor
    ~MsrInfo();

    /// Gets the name of the measurement.
    std::string name() const;

    /// internal method
    virtual measurements::Measurement* create( object_model::DynamicDictionary* object ) const = 0;

    /// Returns the physical information
    PhysicalInformation physicalInformation() const;

    /// Returns the physical dimension
    PhysicalDimension physicalDimension() const;

protected:
    MsrInfoImpl* m_impl;
};

} // namespace imagedev

#pragma warning( pop )
