/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Performs a pointwise arithmetic operation between an image and a value.
class IMAGEDEV_CPP_API ArithmeticOperationWithValue final : public GenericAlgorithm
{
public:
    /// The arithmetic operator to apply.
    enum ArithmeticOperator
    {
    /// The ADD arithmetic operator adds an image I with a constant C.
        ADD = 0,
    /// The SUBTRACT arithmetic operator subtract a constant C from an image I.
        SUBTRACT,
    /// The MULTIPLY arithmetic operator multiplies an image I by a constant C.
        MULTIPLY,
    /// The DIVIDE arithmetic operator divides an image I by a constant C.
        DIVIDE,
    /// The MINIMUM arithmetic operator computes the minimum value between an image I and a constant C.
        MINIMUM,
    /// The MAXIMUM arithmetic operator computes the maximum value between an image I and a constant C.
        MAXIMUM
    };

    // Command constructor.
    ArithmeticOperationWithValue();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the value parameter.
    /// The value to apply.
    double value() const;
    /// Sets the value parameter.
    /// The value to apply.
    void setValue( const double& value );

    /// Gets the arithmeticOperator parameter.
    /// The arithmetic operator to apply.
    ArithmeticOperationWithValue::ArithmeticOperator arithmeticOperator() const;
    /// Sets the arithmeticOperator parameter.
    /// The arithmetic operator to apply.
    void setArithmeticOperator( const ArithmeticOperationWithValue::ArithmeticOperator& arithmeticOperator );

    /// Gets the outputImage parameter.
    /// The output image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Performs a pointwise arithmetic operation between an image and a value.
/// @param inputImage The input image.
/// @param value The value to apply.
/// @param arithmeticOperator The arithmetic operator to apply.
/// @param outputImage The output image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
arithmeticOperationWithValue( std::shared_ptr< iolink::ImageView > inputImage,
                              double value,
                              ArithmeticOperationWithValue::ArithmeticOperator arithmeticOperator,
                              std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
