/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Classifies all pixels of a grayscale image using the k-means clustering method.
class IMAGEDEV_CPP_API AutoIntensityClassification final : public GenericAlgorithm
{
public:

    // Command constructor.
    AutoIntensityClassification();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the classNumber parameter.
    /// The number of classes to detect (the label number of the output).
    int32_t classNumber() const;
    /// Sets the classNumber parameter.
    /// The number of classes to detect (the label number of the output).
    void setClassNumber( const int32_t& classNumber );

    /// Gets the dataPercentage parameter.
    /// The data percentage used for pre-computing the classification.
    int32_t dataPercentage() const;
    /// Sets the dataPercentage parameter.
    /// The data percentage used for pre-computing the classification.
    void setDataPercentage( const int32_t& dataPercentage );

    /// Gets the outputLabelImage parameter.
    /// The output label image where a one label represents one class.
    std::shared_ptr< iolink::ImageView > outputLabelImage() const;
    /// Sets the outputLabelImage parameter.
    /// The output label image where a one label represents one class.
    void setOutputLabelImage( std::shared_ptr< iolink::ImageView > outputLabelImage );

    // Method to launch the command.
    void execute();

};

/// Classifies all pixels of a grayscale image using the k-means clustering method.
/// @param inputImage The input image.
/// @param classNumber The number of classes to detect (the label number of the output).
/// @param dataPercentage The data percentage used for pre-computing the classification.
/// @param outputLabelImage The output label image where a one label represents one class.
/// @return Returns the outputLabelImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
autoIntensityClassification( std::shared_ptr< iolink::ImageView > inputImage,
                             int32_t classNumber,
                             int32_t dataPercentage,
                             std::shared_ptr< iolink::ImageView > outputLabelImage = nullptr );
} // namespace imagedev
