/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Transforms a binary three-dimensional image into another binary image with respect to the real local mean of each voxel neighborhood.
class IMAGEDEV_CPP_API BinarySmoothing3d final : public GenericAlgorithm
{
public:

    // Command constructor.
    BinarySmoothing3d();


    /// Gets the inputBinaryImage parameter.
    /// The input binary image.
    std::shared_ptr< iolink::ImageView > inputBinaryImage() const;
    /// Sets the inputBinaryImage parameter.
    /// The input binary image.
    void setInputBinaryImage( std::shared_ptr< iolink::ImageView > inputBinaryImage );

    /// Gets the kernelRadiusX parameter.
    /// The kernel horizontal half length, in pixels. A value N produces a 2N+1 pixels length.
    int32_t kernelRadiusX() const;
    /// Sets the kernelRadiusX parameter.
    /// The kernel horizontal half length, in pixels. A value N produces a 2N+1 pixels length.
    void setKernelRadiusX( const int32_t& kernelRadiusX );

    /// Gets the kernelRadiusY parameter.
    /// The kernel vertical half length, in pixels. A value N produces a 2N+1 pixels length.
    int32_t kernelRadiusY() const;
    /// Sets the kernelRadiusY parameter.
    /// The kernel vertical half length, in pixels. A value N produces a 2N+1 pixels length.
    void setKernelRadiusY( const int32_t& kernelRadiusY );

    /// Gets the kernelRadiusZ parameter.
    /// The kernel depth half length, in pixels. A value N produces a 2N+1 pixels length.
    int32_t kernelRadiusZ() const;
    /// Sets the kernelRadiusZ parameter.
    /// The kernel depth half length, in pixels. A value N produces a 2N+1 pixels length.
    void setKernelRadiusZ( const int32_t& kernelRadiusZ );

    /// Gets the threshold parameter.
    /// The threshold value applied to the local mean (the minimum volume fraction in the window to set a pixel to 1).
    double threshold() const;
    /// Sets the threshold parameter.
    /// The threshold value applied to the local mean (the minimum volume fraction in the window to set a pixel to 1).
    void setThreshold( const double& threshold );

    /// Gets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Transforms a binary three-dimensional image into another binary image with respect to the real local mean of each voxel neighborhood.
/// @param inputBinaryImage The input binary image.
/// @param kernelRadiusX The kernel horizontal half length, in pixels. A value N produces a 2N+1 pixels length.
/// @param kernelRadiusY The kernel vertical half length, in pixels. A value N produces a 2N+1 pixels length.
/// @param kernelRadiusZ The kernel depth half length, in pixels. A value N produces a 2N+1 pixels length.
/// @param threshold The threshold value applied to the local mean (the minimum volume fraction in the window to set a pixel to 1).
/// @param outputBinaryImage The output binary image. Its dimensions are forced to the same values as the input.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
binarySmoothing3d( std::shared_ptr< iolink::ImageView > inputBinaryImage,
                   int32_t kernelRadiusX,
                   int32_t kernelRadiusY,
                   int32_t kernelRadiusZ,
                   double threshold,
                   std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
