/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/CannyEdgeDetectorMsr.h>

namespace imagedev
{
// Output structure of the cannyEdgeDetector2d function.
struct CannyEdgeDetector2dOutput
{
    /// The output grayscale image representing the detected edges.
    std::shared_ptr< iolink::ImageView > outputImage;
    /// The output measurement provides the estimated parameters of the threshold values used by the hysteresis.
    CannyEdgeDetectorMsr::Ptr outputMeasurement;
};

/// Performs Canny's computational approach to edge detection on a two-dimensional grayscale image.
class IMAGEDEV_CPP_API CannyEdgeDetector2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    CannyEdgeDetector2d();


    /// Gets the inputImage parameter.
    /// The input grayscale image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input grayscale image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the standardDeviation parameter.
    /// The gaussian filter standard deviation value.
    iolink::Vector2d standardDeviation() const;
    /// Sets the standardDeviation parameter.
    /// The gaussian filter standard deviation value.
    void setStandardDeviation( const iolink::Vector2d& standardDeviation );

    /// Gets the outputImage parameter.
    /// The output grayscale image representing the detected edges.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output grayscale image representing the detected edges.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    /// Gets the outputMeasurement parameter.
    /// The output measurement provides the estimated parameters of the threshold values used by the hysteresis.
    CannyEdgeDetectorMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Performs Canny's computational approach to edge detection on a two-dimensional grayscale image.
/// @param inputImage The input grayscale image.
/// @param standardDeviation The gaussian filter standard deviation value.
/// @param outputImage The output grayscale image representing the detected edges.
/// @param outputMeasurement The output measurement provides the estimated parameters of the threshold values used by the hysteresis.
/// @return Returns a CannyEdgeDetector2dOutput structure containing the outputImage and outputMeasurement output parameters.
IMAGEDEV_CPP_API 
CannyEdgeDetector2dOutput
cannyEdgeDetector2d( std::shared_ptr< iolink::ImageView > inputImage,
                     const iolink::Vector2d& standardDeviation,
                     std::shared_ptr< iolink::ImageView > outputImage = nullptr,
                     CannyEdgeDetectorMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
