/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Transforms a color image into a binary image.
class IMAGEDEV_CPP_API ColorThresholding final : public GenericAlgorithm
{
public:

    // Command constructor.
    ColorThresholding();


    /// Gets the inputColorImage parameter.
    /// The input color image.
    std::shared_ptr< iolink::ImageView > inputColorImage() const;
    /// Sets the inputColorImage parameter.
    /// The input color image.
    void setInputColorImage( std::shared_ptr< iolink::ImageView > inputColorImage );

    /// Gets the thresholdRangeRed parameter.
    /// The low and high thresholds for the first channel (red for an RGB image).
    iolink::Vector2d thresholdRangeRed() const;
    /// Sets the thresholdRangeRed parameter.
    /// The low and high thresholds for the first channel (red for an RGB image).
    void setThresholdRangeRed( const iolink::Vector2d& thresholdRangeRed );

    /// Gets the thresholdRangeGreen parameter.
    /// The low and high thresholds for the second channel (green for an RGB image).
    iolink::Vector2d thresholdRangeGreen() const;
    /// Sets the thresholdRangeGreen parameter.
    /// The low and high thresholds for the second channel (green for an RGB image).
    void setThresholdRangeGreen( const iolink::Vector2d& thresholdRangeGreen );

    /// Gets the thresholdRangeBlue parameter.
    /// The low and high thresholds for the third channel (blue for an RGB image).
    iolink::Vector2d thresholdRangeBlue() const;
    /// Sets the thresholdRangeBlue parameter.
    /// The low and high thresholds for the third channel (blue for an RGB image).
    void setThresholdRangeBlue( const iolink::Vector2d& thresholdRangeBlue );

    /// Gets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Transforms a color image into a binary image.
/// @param inputColorImage The input color image.
/// @param thresholdRangeRed The low and high thresholds for the first channel (red for an RGB image).
/// @param thresholdRangeGreen The low and high thresholds for the second channel (green for an RGB image).
/// @param thresholdRangeBlue The low and high thresholds for the third channel (blue for an RGB image).
/// @param outputBinaryImage The output binary image. Its dimensions are forced to the same values as the input.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
colorThresholding( std::shared_ptr< iolink::ImageView > inputColorImage,
                   const iolink::Vector2d& thresholdRangeRed,
                   const iolink::Vector2d& thresholdRangeGreen,
                   const iolink::Vector2d& thresholdRangeBlue,
                   std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
