/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Utilities/Deprecation.h>

namespace imagedev
{
/// Performs a two-dimensional convolution between an image and another image used as a convolution kernel.
class IMAGEDEV_CPP_API ConvolutionWithImage2d final : public GenericAlgorithm
{
public:
    /// The automatic intensity scaling mode.
    enum AutoScale
    {
    /// The result is not normalized.
        NO = 0,
    /// The result is automatically normalized by the sum of the kernel elements.
        YES
    };

    // Command constructor.
    IMAGEDEV_DEPRECATED( "This command is deprecated, it will be removed in ImageDev 2026.1. You can use ConvolutionWithImage instead.") ConvolutionWithImage2d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the inputKernelImage parameter.
    /// The convolution kernel image. It must have odd X and Y dimensions.
    std::shared_ptr< iolink::ImageView > inputKernelImage() const;
    /// Sets the inputKernelImage parameter.
    /// The convolution kernel image. It must have odd X and Y dimensions.
    void setInputKernelImage( std::shared_ptr< iolink::ImageView > inputKernelImage );

    /// Gets the autoScale parameter.
    /// The automatic intensity scaling mode.
    ConvolutionWithImage2d::AutoScale autoScale() const;
    /// Sets the autoScale parameter.
    /// The automatic intensity scaling mode.
    void setAutoScale( const ConvolutionWithImage2d::AutoScale& autoScale );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is promoted.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its data type is promoted.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Performs a two-dimensional convolution between an image and another image used as a convolution kernel.
/// @param inputImage The input image.
/// @param inputKernelImage The convolution kernel image. It must have odd X and Y dimensions.
/// @param autoScale The automatic intensity scaling mode.
/// @param outputImage The output image. Its dimensions are forced to the same values as the input. Its data type is promoted.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
convolutionWithImage2d( std::shared_ptr< iolink::ImageView > inputImage,
                        std::shared_ptr< iolink::ImageView > inputKernelImage,
                        ConvolutionWithImage2d::AutoScale autoScale,
                        std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
