/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <ImageDev/Data/Cuda/CudaContext.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Smoothes an image with a box kernel. The calculations are performed on the GPU.
/// Warning: This command is experimental, his signature may be modified between now and his final version.
class IMAGEDEV_CPP_API CudaBoxFilter2d final : public GenericAlgorithm
{
public:
    /// The way to manage the GPU memory.
    enum TilingMode
    {
    /// The entire input image is transferred to the GPU memory.
        NONE = 0,
    /// The input image is processed by tiles of a predefined size.
        USER_DEFINED
    };

    // Command constructor.
    CudaBoxFilter2d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the kernelSizeX parameter.
    /// The horizontal kernel size.
    uint32_t kernelSizeX() const;
    /// Sets the kernelSizeX parameter.
    /// The horizontal kernel size.
    void setKernelSizeX( const uint32_t& kernelSizeX );

    /// Gets the kernelSizeY parameter.
    /// The vertical kernel size.
    uint32_t kernelSizeY() const;
    /// Sets the kernelSizeY parameter.
    /// The vertical kernel size.
    void setKernelSizeY( const uint32_t& kernelSizeY );

    /// Gets the tilingMode parameter.
    /// The way to manage the GPU memory.
    CudaBoxFilter2d::TilingMode tilingMode() const;
    /// Sets the tilingMode parameter.
    /// The way to manage the GPU memory.
    void setTilingMode( const CudaBoxFilter2d::TilingMode& tilingMode );

    /// Gets the tileSize parameter.
    /// The tile width and height in pixels. This parameter is used only in USER_DEFINED tiling mode.
    iolink::Vector2u32 tileSize() const;
    /// Sets the tileSize parameter.
    /// The tile width and height in pixels. This parameter is used only in USER_DEFINED tiling mode.
    void setTileSize( const iolink::Vector2u32& tileSize );

    /// Gets the cudaContext parameter.
    /// CUDA context information.
    CudaContext::Ptr cudaContext() const;
    /// Sets the cudaContext parameter.
    /// CUDA context information.
    void setCudaContext( const CudaContext::Ptr& cudaContext );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its type is the same as the input if the normalization is set to yes, else the type is upgraded.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions are forced to the same values as the input. Its type is the same as the input if the normalization is set to yes, else the type is upgraded.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Smoothes an image with a box kernel. The calculations are performed on the GPU.
/// Warning: This command is experimental, his signature may be modified between now and his final version.
/// @param inputImage The input image.
/// @param kernelSizeX The horizontal kernel size.
/// @param kernelSizeY The vertical kernel size.
/// @param tilingMode The way to manage the GPU memory.
/// @param tileSize The tile width and height in pixels. This parameter is used only in USER_DEFINED tiling mode.
/// @param cudaContext CUDA context information.
/// @param outputImage The output image. Its dimensions are forced to the same values as the input. Its type is the same as the input if the normalization is set to yes, else the type is upgraded.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
cudaBoxFilter2d( std::shared_ptr< iolink::ImageView > inputImage,
                 uint32_t kernelSizeX,
                 uint32_t kernelSizeY,
                 CudaBoxFilter2d::TilingMode tilingMode,
                 const iolink::Vector2u32& tileSize,
                 CudaContext::Ptr cudaContext,
                 std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
