/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/AnisotropyDegreeMsr.h>

namespace imagedev
{
/// Computes an anisotropy indicator of a binary image with a mean intercept length method.
class IMAGEDEV_CPP_API DegreeOfAnisotropy final : public GenericAlgorithm
{
public:

    // Command constructor.
    DegreeOfAnisotropy();


    /// Gets the inputBinaryImage parameter.
    /// The input binary image.
    std::shared_ptr< iolink::ImageView > inputBinaryImage() const;
    /// Sets the inputBinaryImage parameter.
    /// The input binary image.
    void setInputBinaryImage( std::shared_ptr< iolink::ImageView > inputBinaryImage );

    /// Gets the interceptDistance parameter.
    /// The distance in pixels between two intercept lines.
    int32_t interceptDistance() const;
    /// Sets the interceptDistance parameter.
    /// The distance in pixels between two intercept lines.
    void setInterceptDistance( const int32_t& interceptDistance );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result.
    AnisotropyDegreeMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes an anisotropy indicator of a binary image with a mean intercept length method.
/// @param inputBinaryImage The input binary image.
/// @param interceptDistance The distance in pixels between two intercept lines.
/// @param outputMeasurement The output measurement result.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
AnisotropyDegreeMsr::Ptr
degreeOfAnisotropy( std::shared_ptr< iolink::ImageView > inputBinaryImage,
                    int32_t interceptDistance,
                    AnisotropyDegreeMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
