/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Thresholds an image depending on two grayscale measurements.
class IMAGEDEV_CPP_API FeatureAdaptiveThresholding final : public GenericAlgorithm
{
public:

    // Command constructor.
    FeatureAdaptiveThresholding();


    /// Gets the inputLabelImage parameter.
    /// The input label image.
    std::shared_ptr< iolink::ImageView > inputLabelImage() const;
    /// Sets the inputLabelImage parameter.
    /// The input label image.
    void setInputLabelImage( std::shared_ptr< iolink::ImageView > inputLabelImage );

    /// Gets the inputGrayImage parameter.
    /// The input grayscale image. This image must have same dimensions as the input label image.
    std::shared_ptr< iolink::ImageView > inputGrayImage() const;
    /// Sets the inputGrayImage parameter.
    /// The input grayscale image. This image must have same dimensions as the input label image.
    void setInputGrayImage( std::shared_ptr< iolink::ImageView > inputGrayImage );

    /// Gets the measurementLow parameter.
    /// The measurement defining the lower threshold.
    std::string measurementLow() const;
    /// Sets the measurementLow parameter.
    /// The measurement defining the lower threshold.
    void setMeasurementLow( const std::string& measurementLow );

    /// Gets the measurementHigh parameter.
    /// The measurement defining the higher threshold.
    std::string measurementHigh() const;
    /// Sets the measurementHigh parameter.
    /// The measurement defining the higher threshold.
    void setMeasurementHigh( const std::string& measurementHigh );

    /// Gets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputBinaryImage() const;
    /// Sets the outputBinaryImage parameter.
    /// The output binary image. Its dimensions are forced to the same values as the input.
    void setOutputBinaryImage( std::shared_ptr< iolink::ImageView > outputBinaryImage );

    // Method to launch the command.
    void execute();

};

/// Thresholds an image depending on two grayscale measurements.
/// @param inputLabelImage The input label image.
/// @param inputGrayImage The input grayscale image. This image must have same dimensions as the input label image.
/// @param measurementLow The measurement defining the lower threshold.
/// @param measurementHigh The measurement defining the higher threshold.
/// @param outputBinaryImage The output binary image. Its dimensions are forced to the same values as the input.
/// @return Returns the outputBinaryImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
featureAdaptiveThresholding( std::shared_ptr< iolink::ImageView > inputLabelImage,
                             std::shared_ptr< iolink::ImageView > inputGrayImage,
                             const std::string& measurementLow,
                             const std::string& measurementHigh,
                             std::shared_ptr< iolink::ImageView > outputBinaryImage = nullptr );
} // namespace imagedev
