/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Reconstructs missing areas of an image with an inpainting algorithm.
class IMAGEDEV_CPP_API FlowInpainting final : public GenericAlgorithm
{
public:

    // Command constructor.
    FlowInpainting();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the inputMaskImage parameter.
    /// The input binary image designating the area to reconstruct. It must have same dimensions as the input image.
    std::shared_ptr< iolink::ImageView > inputMaskImage() const;
    /// Sets the inputMaskImage parameter.
    /// The input binary image designating the area to reconstruct. It must have same dimensions as the input image.
    void setInputMaskImage( std::shared_ptr< iolink::ImageView > inputMaskImage );

    /// Gets the numberOfIterations parameter.
    /// The number of iterations (must be a positive integer).
    int32_t numberOfIterations() const;
    /// Sets the numberOfIterations parameter.
    /// The number of iterations (must be a positive integer).
    void setNumberOfIterations( const int32_t& numberOfIterations );

    /// Gets the standardDeviation parameter.
    /// The standard deviation in pixel units.
    double standardDeviation() const;
    /// Sets the standardDeviation parameter.
    /// The standard deviation in pixel units.
    void setStandardDeviation( const double& standardDeviation );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions, type, and calibration are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions, type, and calibration are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Reconstructs missing areas of an image with an inpainting algorithm.
/// @param inputImage The input image.
/// @param inputMaskImage The input binary image designating the area to reconstruct. It must have same dimensions as the input image.
/// @param numberOfIterations The number of iterations (must be a positive integer).
/// @param standardDeviation The standard deviation in pixel units.
/// @param outputImage The output image. Its dimensions, type, and calibration are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
flowInpainting( std::shared_ptr< iolink::ImageView > inputImage,
                std::shared_ptr< iolink::ImageView > inputMaskImage,
                int32_t numberOfIterations,
                double standardDeviation,
                std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
